# LMS Portal - Learning Management System

A comprehensive Laravel + MySQL web application for the LMS Mobile App backend, supporting courses, quizzes, schedules, payments, and performance analytics.

## Features

- **Authentication**: JWT for API, Session for Web (Laravel Breeze)
- **Courses**: Listing, details, enrollment (free/paid), lessons, progress tracking
- **Quizzes**: MCQ quizzes, mock tests, timer, auto-submit, instant results
- **Schedules**: Day/Week/Month planner with reminders
- **Payments**: Razorpay integration (Stripe/PayPal ready)
- **Analytics**: Performance tracking, subject-wise reports
- **User Roles**: Student, Admin, Instructor

## Requirements

- PHP 8.3+
- Composer
- MySQL 8.0+
- Node.js 18+ (for frontend assets)

## Installation

```bash
# Clone/navigate to project
cd lms-portal

# Install PHP dependencies (already done)
composer install

# Configure environment
cp .env.example .env
php artisan key:generate
php artisan jwt:secret

# Edit .env - set MySQL credentials
# DB_CONNECTION=mysql
# DB_DATABASE=lms_portal
# DB_USERNAME=root
# DB_PASSWORD=

# Create database
mysql -u root -p -e "CREATE DATABASE lms_portal;"

# Run migrations
php artisan migrate

# Seed sample data (admin, student, courses, quizzes)
php artisan db:seed

# Build frontend
npm install && npm run build

# Run development server
php artisan serve
```

## Default Login Credentials

| Role   | Email             | Password  |
|--------|-------------------|-----------|
| Admin  | admin@lms.test    | password  |
| Student| student@lms.test  | password  |

## API Endpoints

Base URL: `http://localhost:8000/api`

### Auth (Public)
- `POST /auth/register` - Register
- `POST /auth/login` - Login (returns JWT)

### Auth (Protected - Bearer Token)
- `POST /auth/logout`
- `POST /auth/refresh`
- `GET /auth/me`

### Courses
- `GET /courses` - List courses (public)
- `GET /courses/{id}` - Course details (public)
- `GET /my-courses` - Enrolled courses
- `POST /courses/{id}/enroll` - Enroll (free) or initiate payment

### Quizzes
- `GET /quizzes` - List quizzes
- `GET /quizzes/{id}` - Quiz details
- `POST /quizzes/{id}/start` - Start attempt
- `POST /quiz-attempts/{id}/submit` - Submit attempt
- `POST /quiz-attempts/{id}/answer` - Save answer

### Schedules
- `GET/POST /schedules` - List/Create
- `GET/PUT/DELETE /schedules/{id}` - Show/Update/Delete

### Payments
- `POST /payments/create-order` - Create Razorpay order
- `POST /payments/verify` - Verify payment

## Web Portal Routes

| Route | Description |
|-------|-------------|
| / | Landing page |
| /login, /register | Auth (Breeze) |
| /dashboard | LMS Dashboard |
| /courses | Browse courses |
| /courses/my-courses | Enrolled courses |
| /courses/{id} | Course detail + enroll |
| /quizzes | Browse quizzes |
| /quizzes/{id} | Quiz detail |

## Razorpay Setup

Add to `.env`:
```
RAZORPAY_KEY=your_key
RAZORPAY_SECRET=your_secret
```

## Project Structure

```
app/
├── Http/Controllers/
│   ├── Api/          # JWT API controllers
│   └── Web/          # Web portal controllers
├── Models/           # Eloquent models
database/
├── migrations/       # All LMS tables
└── seeders/         # Sample data
routes/
├── api.php          # API routes
└── web.php          # Web routes
```

## License

MIT
