<?php

namespace App\Console\Commands;

use App\Models\Course;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class FixCourseSlugs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'courses:fix-slugs';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix missing slugs for existing courses';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $courses = Course::whereNull('slug')->orWhere('slug', '')->get();

        if ($courses->isEmpty()) {
            $this->info('All courses already have slugs.');
            return 0;
        }

        $this->info("Found {$courses->count()} courses without slugs. Fixing...");

        $bar = $this->output->createProgressBar($courses->count());
        $bar->start();

        foreach ($courses as $course) {
            $baseSlug = Str::slug($course->title);

            // Ensure uniqueness
            $slug = $baseSlug;
            $counter = 1;
            while (Course::where('slug', $slug)->where('id', '!=', $course->id)->exists()) {
                $slug = $baseSlug . '-' . $counter;
                $counter++;
            }

            $course->slug = $slug ?: Str::random(8);
            $course->save();
            $bar->advance();
        }

        $bar->finish();
        $this->newLine();
        $this->info("Successfully fixed {$courses->count()} course slugs.");

        return 0;
    }
}
