<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CourseEnrollment;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminEnrollmentController extends Controller
{
    public function index(Request $request): View
    {
        $query = CourseEnrollment::with(['user', 'course.category'])
            ->latest('enrolled_at');

        if ($request->search) {
            $query->whereHas('user', function ($q) use ($request) {
                $q->where('name', 'like', '%' . $request->search . '%')
                  ->orWhere('email', 'like', '%' . $request->search . '%');
            })->orWhereHas('course', function ($q) use ($request) {
                $q->where('title', 'like', '%' . $request->search . '%');
            });
        }

        if ($request->course_id) {
            $query->where('course_id', $request->course_id);
        }

        if ($request->status) {
            if ($request->status === 'completed') {
                $query->where('progress_percent', '>=', 100);
            } elseif ($request->status === 'in_progress') {
                $query->where('progress_percent', '>', 0)->where('progress_percent', '<', 100);
            } else {
                $query->where('progress_percent', 0);
            }
        }

        $enrollments = $query->paginate(20)->withQueryString();
        $courses = \App\Models\Course::where('is_active', true)->orderBy('title')->get();

        return view('admin.enrollments.index', compact('enrollments', 'courses'));
    }

    public function show(CourseEnrollment $enrollment): View
    {
        $enrollment->load(['user', 'course.lessons', 'course.category']);
        return view('admin.enrollments.show', compact('enrollment'));
    }

    public function destroy(CourseEnrollment $enrollment)
    {
        $enrollment->delete();
        return redirect()->route('admin.enrollments.index')->with('success', 'Enrollment deleted successfully');
    }
}
