<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CourseEnrollment;
use App\Models\QuizAttempt;
use App\Models\Schedule;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $user = $request->user();

        $enrollments = CourseEnrollment::where('user_id', $user->id)
            ->with('course:id,title,thumbnail,progress_percent')
            ->latest('enrolled_at')
            ->limit(5)
            ->get();

        $recentAttempts = QuizAttempt::where('user_id', $user->id)
            ->where('status', 'submitted')
            ->with('quiz:id,title,subject')
            ->latest('submitted_at')
            ->limit(5)
            ->get();

        $upcomingSchedules = Schedule::where('user_id', $user->id)
            ->where('is_completed', false)
            ->where('schedule_date', '>=', now()->toDateString())
            ->orderBy('schedule_date')
            ->orderBy('start_time')
            ->limit(5)
            ->get();

        $stats = [
            'enrolled_courses' => CourseEnrollment::where('user_id', $user->id)->count(),
            'quizzes_attempted' => QuizAttempt::where('user_id', $user->id)->where('status', 'submitted')->count(),
            'schedules_today' => Schedule::where('user_id', $user->id)
                ->where('schedule_date', now()->toDateString())
                ->where('is_completed', false)
                ->count(),
            'overall_progress' => CourseEnrollment::where('user_id', $user->id)->avg('progress_percent') ?? 0,
        ];

        return response()->json([
            'enrollments' => $enrollments,
            'recent_quiz_attempts' => $recentAttempts,
            'upcoming_schedules' => $upcomingSchedules,
            'stats' => $stats,
        ]);
    }
}
