<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Course;
use App\Models\CourseEnrollment;
use App\Models\Quiz;
use App\Models\Testimonial;
use App\Models\User;

class HomeController extends Controller
{
    public function __invoke()
    {
        $categories = Category::where('is_active', true)->orderBy('sort_order')->get();
        $featuredCourses = Course::with('category')->where('is_active', true)->where('is_featured', true)->latest()->take(6)->get();
        if ($featuredCourses->isEmpty()) {
            $featuredCourses = Course::with('category')->where('is_active', true)->latest()->take(6)->get();
        }
        $freeCourses = Course::with('category')->where('is_active', true)->where('type', 'free')->latest()->take(12)->get();
        $testimonials = Testimonial::where('is_active', true)->orderBy('sort_order')->take(6)->get();
        $stats = [
            'graduates' => User::where('role', 'student')->count() + 5000,
            'countries' => 50,
            'partnerships' => 12,
        ];
        return view('welcome', compact('categories', 'featuredCourses', 'freeCourses', 'testimonials', 'stats'));
    }
}
