<?php

namespace App\Http\Controllers;

use App\Models\Referral;
use Illuminate\Http\Request;

class ReferController extends Controller
{
    public function index()
    {
        $referrals = auth()->check()
            ? Referral::where('referrer_id', auth()->id())->latest()->paginate(10)
            : collect();
        return view('refer.index', compact('referrals'));
    }

    public function store(Request $request)
    {
        $request->validate(['email' => 'nullable|email']);
        $code = Referral::generateCode();
        Referral::create([
            'referrer_id' => auth()->id(),
            'referral_code' => $code,
            'referred_email' => $request->email,
            'status' => 'pending',
        ]);
        return back()->with('success', 'Referral code created: ' . $code);
    }
}
