<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\CourseEnrollment;
use App\Models\QuizAttempt;
use App\Models\Schedule;

class WebDashboardController extends Controller
{
    public function __invoke()
    {
        $user = auth()->user();
        $enrollments = CourseEnrollment::where('user_id', $user->id)
            ->with('course')
            ->whereHas('course', function($query) {
                $query->whereNotNull('slug')->where('slug', '!=', '');
            })
            ->latest('enrolled_at')
            ->limit(5)
            ->get()
            ->filter(fn($e) => $e->course && $e->course->slug);
        $recentAttempts = QuizAttempt::where('user_id', $user->id)
            ->where('status', 'submitted')
            ->with('quiz:id,title')
            ->latest('submitted_at')
            ->limit(5)
            ->get();
        $upcomingSchedules = Schedule::where('user_id', $user->id)
            ->where('is_completed', false)
            ->where('schedule_date', '>=', now()->toDateString())
            ->orderBy('schedule_date')
            ->orderBy('start_time')
            ->limit(5)
            ->get();
        $stats = [
            'courses' => CourseEnrollment::where('user_id', $user->id)->count(),
            'quizzes' => QuizAttempt::where('user_id', $user->id)->where('status', 'submitted')->count(),
            'progress' => round(CourseEnrollment::where('user_id', $user->id)->avg('progress_percent') ?? 0, 1),
        ];
        return view('dashboard', compact('enrollments', 'recentAttempts', 'upcomingSchedules', 'stats'));
    }
}
