<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Quiz;
use Illuminate\Http\Request;
use Illuminate\View\View;

class WebQuizController extends Controller
{
    public function index(Request $request): View
    {
        $query = Quiz::with('category')->where('is_active', true);
        if ($request->type) {
            $query->where('type', $request->type);
        }
        $quizzes = $query->latest()->paginate(12);
        return view('quizzes.index', compact('quizzes'));
    }

    public function show(Quiz $quiz): View
    {
        if (!$quiz->is_active) {
            abort(404);
        }
        $quiz->load('category');
        return view('quizzes.show', compact('quiz'));
    }
}
