<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsAdmin
{
    /**
     * Restrict access to admin routes. Redirect to appropriate login.
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (! $request->user()) {
            return redirect()->guest(route('admin.login'));
        }

        if (! $request->user()->isAdmin()) {
            return redirect()->route('login')
                ->withErrors(['email' => 'Access denied. Admin only.'])
                ->withInput($request->only('email'));
        }

        return $next($request);
    }
}
