<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CourseLesson extends Model
{
    use HasFactory;

    protected $table = 'course_lessons';

    protected $fillable = [
        'course_id',
        'title',
        'content',
        'video_url',
        'file_url',
        'duration',
        'sort_order',
        'is_preview',
        'is_offline_available',
    ];

    protected function casts(): array
    {
        return [
            'is_preview' => 'boolean',
            'is_offline_available' => 'boolean',
        ];
    }

    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class);
    }

    public function progress(): HasMany
    {
        return $this->hasMany(LessonProgress::class, 'course_lesson_id');
    }
}
