<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'admin' => \App\Http\Middleware\EnsureUserIsAdmin::class,
            'user.only' => \App\Http\Middleware\EnsureUserIsNotAdmin::class,
        ]);

        $middleware->redirectGuestsTo(function (Request $request) {
            return $request->is('admin/*') ? route('admin.login') : route('login');
        });
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        $exceptions->renderable(function (ValidationException $e, Request $request): void {
            if (in_array($request->path(), ['login', 'register'], true)) {
                session()->flash('open_auth_modal', true);
                session()->flash('auth_modal_tab', $request->path());
            }
        });
    })->create();
