<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained()->onDelete('cascade');
            $table->foreignId('instructor_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->text('syllabus')->nullable();
            $table->string('thumbnail')->nullable();
            $table->string('demo_video_url')->nullable();
            $table->decimal('price', 10, 2)->default(0);
            $table->enum('type', ['free', 'paid'])->default('free');
            $table->decimal('rating', 3, 2)->default(0);
            $table->integer('total_ratings')->default(0);
            $table->integer('total_lessons')->default(0);
            $table->integer('total_duration')->default(0); // in minutes
            $table->enum('level', ['beginner', 'intermediate', 'advanced', 'all'])->default('all');
            $table->string('exam_type')->nullable(); // SSC, Banking, NEET, IIT, Class 10, etc.
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
