<?php

namespace Database\Seeders;

use App\Models\Testimonial;
use Illuminate\Database\Seeder;

class TestimonialSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            [
                'name' => 'Priya Sharma',
                'role' => 'Banking Aspirant',
                'program' => 'SSC & Banking Prep',
                'quote' => 'The structured courses and mock tests helped me clear my first stage. Progress tracking kept me accountable. I wouldn\'t have been able to do this without an opportunity like this.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'name' => 'Rahul Verma',
                'role' => 'Student',
                'program' => 'Railway Exam',
                'quote' => 'I found the platform very responsive in terms of content and quizzes. Great opportunities for practice. All the course content is right at your fingertips—assignments, progress, and resources.',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'name' => 'Anita Patel',
                'role' => 'NEET Aspirant',
                'program' => 'NEET Preparation',
                'quote' => 'The program has allowed me to continue with school while preparing. The quizzes and schedules helped me stay on track. I highly recommend this for anyone preparing for competitive exams.',
                'sort_order' => 3,
                'is_active' => true,
            ],
        ];

        foreach ($items as $item) {
            Testimonial::updateOrCreate(
                ['name' => $item['name'], 'program' => $item['program']],
                $item
            );
        }
    }
}
