<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Admin Login – {{ config('app.name') }}</title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700,800&display=swap" rel="stylesheet" />
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased bg-slate-100 text-slate-800">
    <div class="min-h-screen flex flex-col justify-center items-center py-12 px-4">
        <a href="{{ route('admin.login') }}" class="text-xl font-bold text-slate-800 tracking-tight">LMS <span class="text-primary-600">Admin</span></a>
        <p class="text-sm text-slate-500 mt-2">Administrator access only</p>

        <div class="w-full sm:max-w-md mt-8 p-8 bg-white rounded-2xl shadow-soft-lg border border-slate-200">
            <h1 class="text-lg font-bold text-slate-900 mb-6">Admin login</h1>

            @if ($errors->any())
                <div class="mb-4 p-3 rounded-xl bg-red-50 border border-red-200 text-red-800 text-sm">
                    {{ $errors->first() }}
                </div>
            @endif

            <form method="POST" action="{{ route('admin.login') }}">
                @csrf

                <div>
                    <label for="email" class="block text-sm font-semibold text-slate-700">Email</label>
                    <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="username"
                           class="input-field mt-1">
                </div>

                <div class="mt-4">
                    <label for="password" class="block text-sm font-semibold text-slate-700">Password</label>
                    <input id="password" type="password" name="password" required autocomplete="current-password"
                           class="input-field mt-1">
                </div>

                <div class="block mt-4">
                    <label class="inline-flex items-center">
                        <input type="checkbox" name="remember" class="rounded border-slate-300 text-primary-600 focus:ring-primary-500">
                        <span class="ml-2 text-sm text-slate-600">Remember me</span>
                    </label>
                </div>

                <div class="flex items-center justify-between mt-6">
                    <a href="{{ route('login') }}" class="text-sm text-slate-500 hover:text-primary-600">User login →</a>
                    <button type="submit" class="btn-primary">Sign in</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
