@extends('layouts.admin')

@section('title', 'Edit Category')
@section('header', 'Edit Category')

@section('content')
<form action="{{ route('admin.categories.update', $category) }}" method="POST" class="max-w-2xl space-y-6">
    @csrf
    @method('PUT')
    <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6 space-y-6">
        <div>
            <label for="name" class="block text-sm font-medium text-slate-700 mb-1">Name</label>
            <input type="text" name="name" id="name" value="{{ old('name', $category->name) }}" required class="input-field">
            @error('name')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
        </div>
        <div>
            <label for="slug" class="block text-sm font-medium text-slate-700 mb-1">Slug</label>
            <input type="text" name="slug" id="slug" value="{{ old('slug', $category->slug) }}" class="input-field">
            @error('slug')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
        </div>
        <div>
            <label for="description" class="block text-sm font-medium text-slate-700 mb-1">Description</label>
            <textarea name="description" id="description" rows="3" class="input-field">{{ old('description', $category->description) }}</textarea>
        </div>
        <div class="flex flex-wrap gap-6">
            <div>
                <label for="sort_order" class="block text-sm font-medium text-slate-700 mb-1">Sort order</label>
                <input type="number" name="sort_order" id="sort_order" value="{{ old('sort_order', $category->sort_order) }}" min="0" class="input-field w-24">
            </div>
            <div class="flex items-center gap-2 pt-6">
                <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $category->is_active) ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <label for="is_active" class="text-sm text-slate-700">Active</label>
            </div>
        </div>
    </div>
    <div class="flex gap-3">
        <button type="submit" class="btn-primary">Update Category</button>
        <a href="{{ route('admin.categories.index') }}" class="btn-secondary">Cancel</a>
    </div>
</form>
@endsection
