@extends('layouts.admin')

@section('title', 'Categories')
@section('header', 'Categories')

@section('content')
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
    <p class="text-slate-600">Manage course categories.</p>
    <a href="{{ route('admin.categories.create') }}" class="btn-primary shrink-0">Add category</a>
</div>

<div class="admin-table-wrap">
    <div class="overflow-x-auto">
        <table class="admin-table min-w-full">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Courses</th>
                    <th>Status</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($categories as $category)
                    <tr>
                        <td class="font-semibold text-slate-800">{{ $category->name }}</td>
                        <td class="text-slate-600">{{ $category->slug }}</td>
                        <td>{{ $category->courses_count }}</td>
                        <td>
                            <span class="text-xs font-semibold px-2.5 py-1 rounded-lg {{ $category->is_active ? 'bg-emerald-100 text-emerald-800' : 'bg-slate-100 text-slate-600' }}">{{ $category->is_active ? 'Active' : 'Inactive' }}</span>
                        </td>
                        <td class="text-right">
                            <a href="{{ route('admin.categories.edit', $category) }}" class="font-semibold text-primary-600 hover:text-primary-700 text-sm">Edit</a>
                            <span class="text-slate-300 mx-1">·</span>
                            <form action="{{ route('admin.categories.destroy', $category) }}" method="POST" class="inline" onsubmit="return confirm('Delete this category?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="font-semibold text-red-600 hover:text-red-700 text-sm">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-14 text-center text-slate-500">
                            No categories yet. <a href="{{ route('admin.categories.create') }}" class="text-primary-600 font-semibold hover:underline">Create one</a>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($categories->hasPages())
        <div class="px-6 py-4 border-t border-slate-200 bg-slate-50/50">{{ $categories->links() }}</div>
    @endif
</div>
@endsection
