@extends('layouts.admin')

@section('title', 'Add Course')
@section('header', 'Add Course')

@section('content')
<form action="{{ route('admin.courses.store') }}" method="POST" class="max-w-3xl space-y-6">
    @csrf
    <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6 space-y-6">
        <div>
            <label for="category_id" class="block text-sm font-medium text-slate-700 mb-1">Category</label>
            <select name="category_id" id="category_id" required class="input-field">
                @foreach($categories as $c)
                    <option value="{{ $c->id }}" {{ old('category_id') == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                @endforeach
            </select>
        </div>
        <div>
            <label for="title" class="block text-sm font-medium text-slate-700 mb-1">Title</label>
            <input type="text" name="title" id="title" value="{{ old('title') }}" required class="input-field">
            @error('title')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
        </div>
        <div>
            <label for="slug" class="block text-sm font-medium text-slate-700 mb-1">Slug (optional)</label>
            <input type="text" name="slug" id="slug" value="{{ old('slug') }}" class="input-field" placeholder="Auto-generated from title if empty">
        </div>
        <div>
            <label for="description" class="block text-sm font-medium text-slate-700 mb-1">Description</label>
            <textarea name="description" id="description" rows="4" class="input-field">{{ old('description') }}</textarea>
        </div>
        <div>
            <label for="syllabus" class="block text-sm font-medium text-slate-700 mb-1">Syllabus</label>
            <textarea name="syllabus" id="syllabus" rows="3" class="input-field">{{ old('syllabus') }}</textarea>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            <div>
                <label for="price" class="block text-sm font-medium text-slate-700 mb-1">Price (₹)</label>
                <input type="number" name="price" id="price" value="{{ old('price', 0) }}" min="0" step="0.01" class="input-field">
            </div>
            <div>
                <label for="type" class="block text-sm font-medium text-slate-700 mb-1">Type</label>
                <select name="type" id="type" class="input-field">
                    <option value="free" {{ old('type', 'free') == 'free' ? 'selected' : '' }}>Free</option>
                    <option value="paid" {{ old('type') == 'paid' ? 'selected' : '' }}>Paid</option>
                </select>
            </div>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            <div>
                <label for="total_lessons" class="block text-sm font-medium text-slate-700 mb-1">Total lessons</label>
                <input type="number" name="total_lessons" id="total_lessons" value="{{ old('total_lessons', 0) }}" min="0" class="input-field">
            </div>
            <div>
                <label for="total_duration" class="block text-sm font-medium text-slate-700 mb-1">Duration (minutes)</label>
                <input type="number" name="total_duration" id="total_duration" value="{{ old('total_duration', 0) }}" min="0" class="input-field">
            </div>
        </div>
        <div>
            <label for="exam_type" class="block text-sm font-medium text-slate-700 mb-1">Exam type</label>
            <input type="text" name="exam_type" id="exam_type" value="{{ old('exam_type') }}" class="input-field" placeholder="e.g. SSC, Banking">
        </div>
        <div class="flex flex-wrap gap-6">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <span class="text-sm text-slate-700">Featured</span>
            </label>
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <span class="text-sm text-slate-700">Active</span>
            </label>
        </div>
    </div>
    <div class="flex gap-3">
        <button type="submit" class="btn-primary">Create Course</button>
        <a href="{{ route('admin.courses.index') }}" class="btn-secondary">Cancel</a>
    </div>
</form>
@endsection
