@extends('layouts.admin')

@section('title', 'Courses')
@section('header', 'Courses')

@section('content')
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
    <p class="text-slate-600">Manage courses and programs.</p>
    <a href="{{ route('admin.courses.create') }}" class="btn-primary shrink-0">Add course</a>
</div>

<div class="admin-table-wrap">
    <div class="overflow-x-auto">
        <table class="admin-table min-w-full">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Status</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($courses as $course)
                    <tr>
                        <td>
                            <a href="{{ route('admin.courses.show', $course) }}" class="font-semibold text-slate-800 hover:text-primary-600 transition">{{ $course->title }}</a>
                        </td>
                        <td>{{ $course->category->name ?? '—' }}</td>
                        <td>
                            <span class="text-xs font-semibold px-2.5 py-1 rounded-lg {{ $course->type === 'free' ? 'bg-emerald-100 text-emerald-800' : 'bg-amber-100 text-amber-800' }}">{{ $course->type }}</span>
                        </td>
                        <td>
                            <span class="text-xs font-semibold px-2.5 py-1 rounded-lg {{ $course->is_active ? 'bg-emerald-100 text-emerald-800' : 'bg-slate-100 text-slate-600' }}">{{ $course->is_active ? 'Active' : 'Inactive' }}</span>
                        </td>
                        <td class="text-right">
                            <a href="{{ route('admin.courses.edit', $course) }}" class="font-semibold text-primary-600 hover:text-primary-700 text-sm">Edit</a>
                            <span class="text-slate-300 mx-1">·</span>
                            <form action="{{ route('admin.courses.destroy', $course) }}" method="POST" class="inline" onsubmit="return confirm('Delete this course?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="font-semibold text-red-600 hover:text-red-700 text-sm">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-14 text-center text-slate-500">
                            No courses yet. <a href="{{ route('admin.courses.create') }}" class="text-primary-600 font-semibold hover:underline">Create one</a>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($courses->hasPages())
        <div class="px-6 py-4 border-t border-slate-200 bg-slate-50/50">{{ $courses->links() }}</div>
    @endif
</div>
@endsection
