@extends('layouts.admin')

@section('title', $course->title)
@section('header', $course->title)

@section('content')
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
    <div class="flex gap-2">
        <span class="badge {{ $course->is_active ? 'badge-success' : 'bg-slate-100 text-slate-600' }}">{{ $course->is_active ? 'Active' : 'Inactive' }}</span>
        <span class="badge {{ $course->type === 'free' ? 'badge-success' : 'badge-warning' }}">{{ $course->type }}</span>
    </div>
    <div class="flex gap-2">
        <a href="{{ route('admin.courses.edit', $course) }}" class="btn-primary">Edit</a>
        <a href="{{ route('admin.courses.index') }}" class="btn-secondary">Back to list</a>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-6">
        <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6">
            <h2 class="font-semibold text-slate-800 mb-4">Details</h2>
            <dl class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
                <div><dt class="text-slate-500">Category</dt><dd class="font-medium text-slate-800">{{ $course->category->name ?? '—' }}</dd></div>
                <div><dt class="text-slate-500">Price</dt><dd class="font-medium text-slate-800">{{ $course->type === 'free' ? 'Free' : '₹' . number_format($course->price) }}</dd></div>
                <div><dt class="text-slate-500">Lessons</dt><dd class="font-medium text-slate-800">{{ $course->total_lessons }}</dd></div>
                <div><dt class="text-slate-500">Duration</dt><dd class="font-medium text-slate-800">{{ $course->total_duration }} min</dd></div>
                <div><dt class="text-slate-500">Exam type</dt><dd class="font-medium text-slate-800">{{ $course->exam_type ?? '—' }}</dd></div>
            </dl>
            @if($course->description)
                <p class="mt-4 text-slate-600">{{ $course->description }}</p>
            @endif
        </div>
        <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="font-semibold text-slate-800">Lessons ({{ $course->lessons->count() }})</h2>
                <a href="{{ route('admin.lessons.create', $course) }}" class="btn-primary text-sm py-2">Add Lesson</a>
            </div>
            @if($course->lessons->count())
                <div class="admin-table-wrap">
                    <table class="admin-table w-full">
                        <thead>
                            <tr>
                                <th>Order</th>
                                <th>Title</th>
                                <th>Duration</th>
                                <th>Preview</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($course->lessons->sortBy('sort_order') as $lesson)
                                <tr>
                                    <td class="font-semibold text-slate-600">{{ $lesson->sort_order }}</td>
                                    <td>
                                        <p class="font-medium text-slate-800">{{ $lesson->title }}</p>
                                        @if($lesson->content)
                                            <p class="text-xs text-slate-500 mt-1">{{ \Illuminate\Support\Str::limit($lesson->content, 50) }}</p>
                                        @endif
                                    </td>
                                    <td class="text-slate-600">{{ $lesson->duration }} min</td>
                                    <td>
                                        @if($lesson->is_preview)
                                            <span class="badge-primary">Preview</span>
                                        @else
                                            <span class="text-slate-400">—</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="flex items-center gap-2">
                                            <a href="{{ route('admin.lessons.edit', ['course' => $course, 'lesson' => $lesson]) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">Edit</a>
                                            <form action="{{ route('admin.lessons.destroy', ['course' => $course, 'lesson' => $lesson]) }}" method="POST" onsubmit="return confirm('Are you sure?')" class="inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="text-sm text-red-600 hover:text-red-700 font-semibold">Delete</button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-8">
                    <p class="text-slate-500 mb-4">No lessons added yet.</p>
                    <a href="{{ route('admin.lessons.create', $course) }}" class="btn-primary inline-flex">Add First Lesson</a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
