@extends('layouts.admin')

@section('title', 'Dashboard')
@section('header', 'Dashboard')

@section('content')
<div class="space-y-8">
    {{-- Stats Grid --}}
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="stat-card">
            <div class="flex items-center justify-between">
                <div>
                    <p class="stat-label">Total Students</p>
                    <p class="stat-value">{{ number_format($stats['total_students']) }}</p>
                    <p class="text-xs text-slate-500 mt-1">{{ $stats['total_users'] }} total users</p>
                </div>
                <div class="w-14 h-14 rounded-2xl bg-primary-100 flex items-center justify-center">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                </div>
            </div>
        </div>
        <div class="stat-card">
            <div class="flex items-center justify-between">
                <div>
                    <p class="stat-label">Active Courses</p>
                    <p class="stat-value">{{ number_format($stats['active_courses']) }}</p>
                    <p class="text-xs text-slate-500 mt-1">{{ $stats['total_courses'] }} total courses</p>
                </div>
                <div class="w-14 h-14 rounded-2xl bg-blue-100 flex items-center justify-center">
                    <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                </div>
            </div>
        </div>
        <div class="stat-card">
            <div class="flex items-center justify-between">
                <div>
                    <p class="stat-label">Total Enrollments</p>
                    <p class="stat-value">{{ number_format($stats['total_enrollments']) }}</p>
                    <p class="text-xs text-slate-500 mt-1">{{ $stats['completed_enrollments'] }} completed</p>
                </div>
                <div class="w-14 h-14 rounded-2xl bg-amber-100 flex items-center justify-center">
                    <svg class="w-7 h-7 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                </div>
            </div>
        </div>
        <div class="stat-card">
            <div class="flex items-center justify-between">
                <div>
                    <p class="stat-label">Total Revenue</p>
                    <p class="stat-value">₹{{ number_format($stats['total_revenue']) }}</p>
                    <p class="text-xs text-slate-500 mt-1">{{ $stats['total_instructors'] }} instructors</p>
                </div>
                <div class="w-14 h-14 rounded-2xl bg-emerald-100 flex items-center justify-center">
                    <svg class="w-7 h-7 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                </div>
            </div>
        </div>
    </div>

    {{-- Top Courses & Recent Activity --}}
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="card overflow-hidden">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                <h2 class="font-bold text-slate-800">Top Performing Courses</h2>
                <a href="{{ route('admin.courses.index') }}" class="text-xs text-primary-600 hover:text-primary-700 font-semibold">View all</a>
            </div>
            <div class="divide-y divide-slate-100">
                @forelse($topCourses as $course)
                    <a href="{{ route('admin.courses.show', $course) }}" class="flex items-center gap-4 px-6 py-4 hover:bg-slate-50/80 transition">
                        <div class="w-12 h-12 rounded-xl bg-slate-100 flex items-center justify-center text-slate-500 shrink-0">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="font-semibold text-slate-800 truncate">{{ $course->title }}</p>
                            <p class="text-sm text-slate-500">{{ $course->category->name ?? '—' }}</p>
                        </div>
                        <div class="text-right shrink-0">
                            <p class="text-sm font-bold text-slate-900">{{ $course->enrollments_count }}</p>
                            <p class="text-xs text-slate-500">enrollments</p>
                        </div>
                    </a>
                @empty
                    <p class="px-6 py-10 text-slate-500 text-center">No courses yet.</p>
                @endforelse
            </div>
        </div>

        <div class="card overflow-hidden">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                <h2 class="font-bold text-slate-800">Recent Enrollments</h2>
                <a href="{{ route('admin.enrollments.index') }}" class="text-xs text-primary-600 hover:text-primary-700 font-semibold">View all</a>
            </div>
            <div class="divide-y divide-slate-100">
                @forelse($recentEnrollments as $enrollment)
                    <div class="flex items-center gap-4 px-6 py-4 hover:bg-slate-50/80 transition">
                        <div class="w-11 h-11 rounded-xl bg-primary-100 flex items-center justify-center text-primary-700 font-bold shrink-0 text-sm">
                            {{ strtoupper(substr($enrollment->user->name, 0, 1)) }}
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="font-semibold text-slate-800 truncate">{{ $enrollment->user->name }}</p>
                            <p class="text-sm text-slate-500 truncate">{{ $enrollment->course->title }}</p>
                        </div>
                        <div class="text-right shrink-0">
                            <p class="text-xs font-semibold text-slate-600">{{ $enrollment->progress_percent }}%</p>
                            <p class="text-xs text-slate-500">{{ $enrollment->enrolled_at->diffForHumans() }}</p>
                        </div>
                    </div>
                @empty
                    <p class="px-6 py-10 text-slate-500 text-center">No enrollments yet.</p>
                @endforelse
            </div>
        </div>
    </div>

    {{-- Course Performance Table --}}
    <div class="card overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
            <h2 class="font-bold text-slate-800">Course Performance</h2>
            <a href="{{ route('admin.reports.index') }}" class="text-xs text-primary-600 hover:text-primary-700 font-semibold">View detailed reports</a>
        </div>
        <div class="admin-table-wrap">
            <table class="admin-table w-full">
                <thead>
                    <tr>
                        <th>Course</th>
                        <th>Category</th>
                        <th>Enrollments</th>
                        <th>Avg Progress</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($coursePerformance as $course)
                        <tr>
                            <td>
                                <a href="{{ route('admin.courses.show', $course) }}" class="font-semibold text-slate-800 hover:text-primary-600 transition">
                                    {{ $course->title }}
                                </a>
                            </td>
                            <td class="text-slate-600">{{ $course->category->name ?? '—' }}</td>
                            <td class="font-semibold">{{ $course->enrollments_count }}</td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <div class="w-16 bg-slate-200 rounded-full h-2">
                                        <div class="bg-primary-600 h-2 rounded-full" style="width: {{ round($course->enrollments_avg_progress_percent ?? 0) }}%"></div>
                                    </div>
                                    <span class="text-sm text-slate-600">{{ round($course->enrollments_avg_progress_percent ?? 0) }}%</span>
                                </div>
                            </td>
                            <td>
                                <span class="text-xs font-semibold px-2.5 py-1 rounded-lg {{ $course->is_active ? 'bg-emerald-100 text-emerald-800' : 'bg-slate-100 text-slate-600' }}">
                                    {{ $course->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('admin.courses.show', $course) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-10 text-slate-500">No courses found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
