@extends('layouts.admin')

@section('title', 'Enrollments')
@section('header', 'Enrollments Management')

@section('content')
<div class="space-y-6">
    {{-- Filters --}}
    <div class="card">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.enrollments.index') }}" class="flex flex-wrap gap-4">
                <div class="flex-1 min-w-[200px]">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by student or course..." class="input-field">
                </div>
                <div class="min-w-[180px]">
                    <select name="course_id" class="input-field">
                        <option value="">All Courses</option>
                        @foreach($courses as $course)
                            <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                                {{ $course->title }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="min-w-[150px]">
                    <select name="status" class="input-field">
                        <option value="">All Status</option>
                        <option value="not_started" {{ request('status') === 'not_started' ? 'selected' : '' }}>Not Started</option>
                        <option value="in_progress" {{ request('status') === 'in_progress' ? 'selected' : '' }}>In Progress</option>
                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
                    </select>
                </div>
                <button type="submit" class="btn-primary">Filter</button>
                @if(request()->hasAny(['search', 'course_id', 'status']))
                    <a href="{{ route('admin.enrollments.index') }}" class="btn-secondary">Clear</a>
                @endif
            </form>
        </div>
    </div>

    {{-- Enrollments Table --}}
    <div class="card overflow-hidden">
        <div class="admin-table-wrap">
            <table class="admin-table w-full">
                <thead>
                    <tr>
                        <th>Student</th>
                        <th>Course</th>
                        <th>Progress</th>
                        <th>Enrolled Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($enrollments as $enrollment)
                        <tr>
                            <td>
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-primary-100 flex items-center justify-center text-primary-700 font-bold text-sm">
                                        {{ strtoupper(substr($enrollment->user->name, 0, 1)) }}
                                    </div>
                                    <div>
                                        <p class="font-semibold text-slate-800">{{ $enrollment->user->name }}</p>
                                        <p class="text-xs text-slate-500">{{ $enrollment->user->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <p class="font-medium text-slate-800">{{ $enrollment->course->title }}</p>
                                <p class="text-xs text-slate-500">{{ $enrollment->course->category->name ?? '—' }}</p>
                            </td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <div class="w-24 bg-slate-200 rounded-full h-2">
                                        <div class="bg-primary-600 h-2 rounded-full transition-all" style="width: {{ $enrollment->progress_percent }}%"></div>
                                    </div>
                                    <span class="text-sm font-semibold text-slate-700">{{ $enrollment->progress_percent }}%</span>
                                </div>
                            </td>
                            <td class="text-slate-600">{{ $enrollment->enrolled_at->format('M d, Y') }}</td>
                            <td>
                                @if($enrollment->progress_percent >= 100)
                                    <span class="badge-success">Completed</span>
                                @elseif($enrollment->progress_percent > 0)
                                    <span class="badge-primary">In Progress</span>
                                @else
                                    <span class="badge bg-slate-100 text-slate-600">Not Started</span>
                                @endif
                            </td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('admin.enrollments.show', $enrollment) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">View</a>
                                    <form action="{{ route('admin.enrollments.destroy', $enrollment) }}" method="POST" onsubmit="return confirm('Are you sure?')" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-sm text-red-600 hover:text-red-700 font-semibold">Delete</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-10 text-slate-500">No enrollments found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($enrollments->hasPages())
            <div class="px-6 py-4 border-t border-slate-100">
                {{ $enrollments->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
