@extends('layouts.admin')

@section('title', 'Enrollment Details')
@section('header', 'Enrollment Details')

@section('content')
<div class="space-y-6">
    <div class="card">
        <div class="card-body">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <h3 class="font-bold text-slate-900 mb-4">Student Information</h3>
                    <dl class="space-y-3">
                        <div>
                            <dt class="text-sm text-slate-500">Name</dt>
                            <dd class="font-semibold text-slate-900">{{ $enrollment->user->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-slate-500">Email</dt>
                            <dd class="text-slate-700">{{ $enrollment->user->email }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-slate-500">Role</dt>
                            <dd><span class="badge bg-slate-100 text-slate-600">{{ $enrollment->user->role }}</span></dd>
                        </div>
                    </dl>
                </div>
                <div>
                    <h3 class="font-bold text-slate-900 mb-4">Course Information</h3>
                    <dl class="space-y-3">
                        <div>
                            <dt class="text-sm text-slate-500">Course</dt>
                            <dd class="font-semibold text-slate-900">{{ $enrollment->course->title }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-slate-500">Category</dt>
                            <dd class="text-slate-700">{{ $enrollment->course->category->name ?? '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-slate-500">Type</dt>
                            <dd>
                                <span class="badge {{ $enrollment->course->type === 'free' ? 'badge-success' : 'badge-warning' }}">
                                    {{ $enrollment->course->type }}
                                </span>
                            </dd>
                        </div>
                    </dl>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <h3 class="font-bold text-slate-900 mb-4">Progress</h3>
            <div class="space-y-4">
                <div>
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-sm font-semibold text-slate-700">Overall Progress</span>
                        <span class="text-lg font-bold text-primary-600">{{ $enrollment->progress_percent }}%</span>
                    </div>
                    <div class="w-full bg-slate-200 rounded-full h-3">
                        <div class="bg-primary-600 h-3 rounded-full transition-all" style="width: {{ $enrollment->progress_percent }}%"></div>
                    </div>
                </div>
                <div>
                    <dt class="text-sm text-slate-500">Enrolled Date</dt>
                    <dd class="text-slate-700">{{ $enrollment->enrolled_at->format('F d, Y h:i A') }}</dd>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <h3 class="font-bold text-slate-900 mb-4">Course Lessons</h3>
            @if($enrollment->course->lessons->count())
                <div class="space-y-2">
                    @foreach($enrollment->course->lessons->sortBy('sort_order') as $lesson)
                        <div class="flex items-center justify-between p-3 rounded-lg border border-slate-200">
                            <div class="flex items-center gap-3">
                                <span class="text-sm font-semibold text-slate-600 w-8">{{ $lesson->sort_order }}</span>
                                <span class="font-medium text-slate-800">{{ $lesson->title }}</span>
                            </div>
                            <span class="text-sm text-slate-500">{{ $lesson->duration }} min</span>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-slate-500">No lessons available.</p>
            @endif
        </div>
    </div>

    <div class="flex items-center gap-4">
        <form action="{{ route('admin.enrollments.destroy', $enrollment) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this enrollment?')">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn-secondary text-red-600 hover:text-red-700 border-red-200">Delete Enrollment</button>
        </form>
        <a href="{{ route('admin.enrollments.index') }}" class="btn-secondary">Back to Enrollments</a>
    </div>
</div>
@endsection
