@extends('layouts.admin')

@section('title', 'Add Instructor')
@section('header', 'Add New Instructor')

@section('content')
<div class="max-w-2xl">
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.instructors.store') }}" method="POST">
                @csrf
                <div class="space-y-6">
                    <div>
                        <label for="name" class="block text-sm font-semibold text-slate-700 mb-1.5">Name *</label>
                        <input type="text" id="name" name="name" value="{{ old('name') }}" required class="input-field">
                        @error('name')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="email" class="block text-sm font-semibold text-slate-700 mb-1.5">Email *</label>
                        <input type="email" id="email" name="email" value="{{ old('email') }}" required class="input-field">
                        @error('email')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="password" class="block text-sm font-semibold text-slate-700 mb-1.5">Password *</label>
                        <input type="password" id="password" name="password" required minlength="8" class="input-field">
                        @error('password')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div class="flex items-center gap-4 pt-4">
                        <button type="submit" class="btn-primary">Create Instructor</button>
                        <a href="{{ route('admin.instructors.index') }}" class="btn-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
