@extends('layouts.admin')

@section('title', 'Instructors')
@section('header', 'Instructors Management')

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-xl font-bold text-slate-900">All Instructors</h2>
            <p class="text-slate-600 mt-1">Manage instructors and their courses</p>
        </div>
        <a href="{{ route('admin.instructors.create') }}" class="btn-primary">Add Instructor</a>
    </div>

    {{-- Search --}}
    <div class="card">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.instructors.index') }}" class="flex gap-4">
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search instructors..." class="input-field flex-1">
                <button type="submit" class="btn-primary">Search</button>
                @if(request('search'))
                    <a href="{{ route('admin.instructors.index') }}" class="btn-secondary">Clear</a>
                @endif
            </form>
        </div>
    </div>

    {{-- Instructors Grid --}}
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @forelse($instructors as $instructor)
            <div class="card overflow-hidden">
                <div class="card-body">
                    <div class="flex items-start gap-4">
                        <div class="w-16 h-16 rounded-xl bg-primary-100 flex items-center justify-center text-primary-700 text-xl font-bold shrink-0">
                            {{ strtoupper(substr($instructor->name, 0, 1)) }}
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="font-bold text-slate-900 truncate">{{ $instructor->name }}</h3>
                            <p class="text-sm text-slate-500 truncate">{{ $instructor->email }}</p>
                            <p class="text-sm font-semibold text-primary-600 mt-2">{{ $instructor->courses_count }} courses</p>
                        </div>
                    </div>
                    <div class="mt-4 pt-4 border-t border-slate-100 flex items-center gap-2">
                        <a href="{{ route('admin.instructors.show', $instructor) }}" class="btn-secondary flex-1 text-center text-sm py-2">View</a>
                        <a href="{{ route('admin.instructors.edit', $instructor) }}" class="btn-outline flex-1 text-center text-sm py-2">Edit</a>
                        <form action="{{ route('admin.instructors.destroy', $instructor) }}" method="POST" onsubmit="return confirm('Are you sure?')" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-sm text-red-600 hover:text-red-700 font-semibold px-3 py-2">Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <div class="card">
                    <div class="card-body text-center py-12">
                        <p class="text-slate-500 mb-4">No instructors found.</p>
                        <a href="{{ route('admin.instructors.create') }}" class="btn-primary inline-flex">Add First Instructor</a>
                    </div>
                </div>
            </div>
        @endforelse
    </div>

    @if($instructors->hasPages())
        <div class="flex justify-center">
            {{ $instructors->links() }}
        </div>
    @endif
</div>
@endsection
