@extends('layouts.admin')

@section('title', $instructor->name)
@section('header', $instructor->name)

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div class="flex items-center gap-4">
            <div class="w-20 h-20 rounded-xl bg-primary-100 flex items-center justify-center text-primary-700 text-2xl font-bold">
                {{ strtoupper(substr($instructor->name, 0, 1)) }}
            </div>
            <div>
                <h2 class="text-2xl font-bold text-slate-900">{{ $instructor->name }}</h2>
                <p class="text-slate-600">{{ $instructor->email }}</p>
            </div>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('admin.instructors.edit', $instructor) }}" class="btn-primary">Edit</a>
            <a href="{{ route('admin.instructors.index') }}" class="btn-secondary">Back</a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <h3 class="font-bold text-slate-900 mb-4">Courses Taught ({{ $instructor->courses->count() }})</h3>
            @if($instructor->courses->count())
                <div class="admin-table-wrap">
                    <table class="admin-table w-full">
                        <thead>
                            <tr>
                                <th>Course</th>
                                <th>Category</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($instructor->courses as $course)
                                <tr>
                                    <td>
                                        <a href="{{ route('admin.courses.show', $course) }}" class="font-semibold text-slate-800 hover:text-primary-600">
                                            {{ $course->title }}
                                        </a>
                                    </td>
                                    <td class="text-slate-600">{{ $course->category->name ?? '—' }}</td>
                                    <td>
                                        <span class="badge {{ $course->type === 'free' ? 'badge-success' : 'badge-warning' }}">
                                            {{ $course->type }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge {{ $course->is_active ? 'badge-success' : 'bg-slate-100 text-slate-600' }}">
                                            {{ $course->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.courses.show', $course) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">View</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-slate-500">No courses assigned yet.</p>
            @endif
        </div>
    </div>
</div>
@endsection
