@extends('layouts.admin')

@section('title', 'Edit Lesson')
@section('header', 'Edit Lesson: ' . $lesson->title)

@section('content')
<div class="max-w-3xl">
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.lessons.update', ['course' => $course, 'lesson' => $lesson]) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="space-y-6">
                    <div>
                        <label for="title" class="block text-sm font-semibold text-slate-700 mb-1.5">Lesson Title *</label>
                        <input type="text" id="title" name="title" value="{{ old('title', $lesson->title) }}" required class="input-field">
                        @error('title')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="content" class="block text-sm font-semibold text-slate-700 mb-1.5">Description/Content</label>
                        <textarea id="content" name="content" rows="4" class="input-field">{{ old('content', $lesson->content) }}</textarea>
                        @error('content')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="video_url" class="block text-sm font-semibold text-slate-700 mb-1.5">Video URL</label>
                            <input type="url" id="video_url" name="video_url" value="{{ old('video_url', $lesson->video_url) }}" class="input-field">
                            @error('video_url')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                        </div>
                        <div>
                            <label for="file_url" class="block text-sm font-semibold text-slate-700 mb-1.5">File/Resource URL</label>
                            <input type="url" id="file_url" name="file_url" value="{{ old('file_url', $lesson->file_url) }}" class="input-field">
                            @error('file_url')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="duration" class="block text-sm font-semibold text-slate-700 mb-1.5">Duration (minutes) *</label>
                            <input type="number" id="duration" name="duration" value="{{ old('duration', $lesson->duration) }}" required min="1" class="input-field">
                            @error('duration')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                        </div>
                        <div>
                            <label for="sort_order" class="block text-sm font-semibold text-slate-700 mb-1.5">Sort Order *</label>
                            <input type="number" id="sort_order" name="sort_order" value="{{ old('sort_order', $lesson->sort_order) }}" required min="0" class="input-field">
                            @error('sort_order')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                        </div>
                    </div>
                    <div class="flex items-center gap-6">
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="checkbox" name="is_preview" value="1" {{ old('is_preview', $lesson->is_preview) ? 'checked' : '' }} class="rounded border-slate-300 text-primary-600 focus:ring-primary-500">
                            <span class="text-sm font-semibold text-slate-700">Available as Preview</span>
                        </label>
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="checkbox" name="is_offline_available" value="1" {{ old('is_offline_available', $lesson->is_offline_available) ? 'checked' : '' }} class="rounded border-slate-300 text-primary-600 focus:ring-primary-500">
                            <span class="text-sm font-semibold text-slate-700">Offline Available</span>
                        </label>
                    </div>
                    <div class="flex items-center gap-4 pt-4">
                        <button type="submit" class="btn-primary">Update Lesson</button>
                        <a href="{{ route('admin.courses.show', $course) }}" class="btn-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
