@extends('layouts.admin')

@section('title', 'Add Quiz')
@section('header', 'Add Quiz')

@section('content')
<form action="{{ route('admin.quizzes.store') }}" method="POST" class="max-w-3xl space-y-6">
    @csrf
    <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6 space-y-6">
        <div>
            <label for="category_id" class="block text-sm font-medium text-slate-700 mb-1">Category</label>
            <select name="category_id" id="category_id" class="input-field">
                <option value="">— None —</option>
                @foreach($categories as $c)
                    <option value="{{ $c->id }}" {{ old('category_id') == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                @endforeach
            </select>
        </div>
        <div>
            <label for="title" class="block text-sm font-medium text-slate-700 mb-1">Title</label>
            <input type="text" name="title" id="title" value="{{ old('title') }}" required class="input-field">
            @error('title')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
        </div>
        <div>
            <label for="description" class="block text-sm font-medium text-slate-700 mb-1">Description</label>
            <textarea name="description" id="description" rows="3" class="input-field">{{ old('description') }}</textarea>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            <div>
                <label for="type" class="block text-sm font-medium text-slate-700 mb-1">Type</label>
                <select name="type" id="type" class="input-field">
                    <option value="practice" {{ old('type', 'practice') == 'practice' ? 'selected' : '' }}>Practice</option>
                    <option value="mock" {{ old('type') == 'mock' ? 'selected' : '' }}>Mock</option>
                    <option value="subject_wise" {{ old('type') == 'subject_wise' ? 'selected' : '' }}>Subject-wise</option>
                    <option value="full_length" {{ old('type') == 'full_length' ? 'selected' : '' }}>Full length</option>
                </select>
            </div>
            <div>
                <label for="subject" class="block text-sm font-medium text-slate-700 mb-1">Subject</label>
                <input type="text" name="subject" id="subject" value="{{ old('subject') }}" class="input-field">
            </div>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
            <div>
                <label for="total_questions" class="block text-sm font-medium text-slate-700 mb-1">Total questions</label>
                <input type="number" name="total_questions" id="total_questions" value="{{ old('total_questions', 10) }}" min="1" class="input-field">
            </div>
            <div>
                <label for="duration" class="block text-sm font-medium text-slate-700 mb-1">Duration (min)</label>
                <input type="number" name="duration" id="duration" value="{{ old('duration', 30) }}" min="1" class="input-field">
            </div>
            <div>
                <label for="passing_percent" class="block text-sm font-medium text-slate-700 mb-1">Passing %</label>
                <input type="number" name="passing_percent" id="passing_percent" value="{{ old('passing_percent', 40) }}" min="0" max="100" class="input-field">
            </div>
        </div>
        <div>
            <label for="price" class="block text-sm font-medium text-slate-700 mb-1">Price (₹)</label>
            <input type="number" name="price" id="price" value="{{ old('price', 0) }}" min="0" step="0.01" class="input-field">
        </div>
        <div class="flex flex-wrap gap-6">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_free" value="1" {{ old('is_free', true) ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <span class="text-sm text-slate-700">Free</span>
            </label>
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <span class="text-sm text-slate-700">Active</span>
            </label>
        </div>
    </div>
    <div class="flex gap-3">
        <button type="submit" class="btn-primary">Create Quiz</button>
        <a href="{{ route('admin.quizzes.index') }}" class="btn-secondary">Cancel</a>
    </div>
</form>
@endsection
