@extends('layouts.admin')

@section('title', 'Edit Quiz')
@section('header', 'Edit Quiz')

@section('content')
<form action="{{ route('admin.quizzes.update', $quiz) }}" method="POST" class="max-w-3xl space-y-6">
    @csrf
    @method('PUT')
    <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6 space-y-6">
        <div>
            <label for="category_id" class="block text-sm font-medium text-slate-700 mb-1">Category</label>
            <select name="category_id" id="category_id" class="input-field">
                <option value="">— None —</option>
                @foreach($categories as $c)
                    <option value="{{ $c->id }}" {{ old('category_id', $quiz->category_id) == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                @endforeach
            </select>
        </div>
        <div>
            <label for="title" class="block text-sm font-medium text-slate-700 mb-1">Title</label>
            <input type="text" name="title" id="title" value="{{ old('title', $quiz->title) }}" required class="input-field">
        </div>
        <div>
            <label for="description" class="block text-sm font-medium text-slate-700 mb-1">Description</label>
            <textarea name="description" id="description" rows="3" class="input-field">{{ old('description', $quiz->description) }}</textarea>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            <div>
                <label for="type" class="block text-sm font-medium text-slate-700 mb-1">Type</label>
                <select name="type" id="type" class="input-field">
                    @foreach(['practice','mock','subject_wise','full_length'] as $t)
                        <option value="{{ $t }}" {{ old('type', $quiz->type) == $t ? 'selected' : '' }}>{{ ucfirst(str_replace('_',' ',$t)) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="subject" class="block text-sm font-medium text-slate-700 mb-1">Subject</label>
                <input type="text" name="subject" id="subject" value="{{ old('subject', $quiz->subject) }}" class="input-field">
            </div>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
            <div>
                <label for="total_questions" class="block text-sm font-medium text-slate-700 mb-1">Total questions</label>
                <input type="number" name="total_questions" id="total_questions" value="{{ old('total_questions', $quiz->total_questions) }}" min="1" class="input-field">
            </div>
            <div>
                <label for="duration" class="block text-sm font-medium text-slate-700 mb-1">Duration (min)</label>
                <input type="number" name="duration" id="duration" value="{{ old('duration', $quiz->duration) }}" min="1" class="input-field">
            </div>
            <div>
                <label for="passing_percent" class="block text-sm font-medium text-slate-700 mb-1">Passing %</label>
                <input type="number" name="passing_percent" id="passing_percent" value="{{ old('passing_percent', $quiz->passing_percent) }}" min="0" max="100" class="input-field">
            </div>
        </div>
        <div>
            <label for="price" class="block text-sm font-medium text-slate-700 mb-1">Price (₹)</label>
            <input type="number" name="price" id="price" value="{{ old('price', $quiz->price) }}" min="0" step="0.01" class="input-field">
        </div>
        <div class="flex flex-wrap gap-6">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_free" value="1" {{ old('is_free', $quiz->is_free) ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <span class="text-sm text-slate-700">Free</span>
            </label>
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $quiz->is_active) ? 'checked' : '' }} class="rounded border-slate-300 text-teal-600 focus:ring-teal-500">
                <span class="text-sm text-slate-700">Active</span>
            </label>
        </div>
    </div>
    <div class="flex gap-3">
        <button type="submit" class="btn-primary">Update Quiz</button>
        <a href="{{ route('admin.quizzes.index') }}" class="btn-secondary">Cancel</a>
    </div>
</form>
@endsection
