@extends('layouts.admin')

@section('title', 'Quizzes')
@section('header', 'Quizzes')

@section('content')
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
    <p class="text-slate-600">Manage quizzes and mock tests.</p>
    <a href="{{ route('admin.quizzes.create') }}" class="btn-primary shrink-0">Add quiz</a>
</div>

<div class="admin-table-wrap">
    <div class="overflow-x-auto">
        <table class="admin-table min-w-full">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Questions</th>
                    <th>Duration</th>
                    <th>Status</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($quizzes as $quiz)
                    <tr>
                        <td>
                            <a href="{{ route('admin.quizzes.show', $quiz) }}" class="font-semibold text-slate-800 hover:text-primary-600 transition">{{ $quiz->title }}</a>
                        </td>
                        <td class="text-slate-600">{{ $quiz->type }}</td>
                        <td>{{ $quiz->total_questions }}</td>
                        <td class="text-slate-600">{{ $quiz->duration }} min</td>
                        <td>
                            <span class="text-xs font-semibold px-2.5 py-1 rounded-lg {{ $quiz->is_active ? 'bg-emerald-100 text-emerald-800' : 'bg-slate-100 text-slate-600' }}">{{ $quiz->is_active ? 'Active' : 'Inactive' }}</span>
                        </td>
                        <td class="text-right">
                            <a href="{{ route('admin.quizzes.edit', $quiz) }}" class="font-semibold text-primary-600 hover:text-primary-700 text-sm">Edit</a>
                            <span class="text-slate-300 mx-1">·</span>
                            <form action="{{ route('admin.quizzes.destroy', $quiz) }}" method="POST" class="inline" onsubmit="return confirm('Delete this quiz?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="font-semibold text-red-600 hover:text-red-700 text-sm">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-14 text-center text-slate-500">
                            No quizzes yet. <a href="{{ route('admin.quizzes.create') }}" class="text-primary-600 font-semibold hover:underline">Create one</a>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($quizzes->hasPages())
        <div class="px-6 py-4 border-t border-slate-200 bg-slate-50/50">{{ $quizzes->links() }}</div>
    @endif
</div>
@endsection
