@extends('layouts.admin')

@section('title', $quiz->title)
@section('header', $quiz->title)

@section('content')
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
    <div class="flex gap-2">
        <span class="badge {{ $quiz->is_active ? 'badge-success' : 'bg-slate-100 text-slate-600' }}">{{ $quiz->is_active ? 'Active' : 'Inactive' }}</span>
        <span class="badge badge-primary">{{ $quiz->type }}</span>
    </div>
    <div class="flex gap-2">
        <a href="{{ route('admin.quizzes.edit', $quiz) }}" class="btn-primary">Edit</a>
        <a href="{{ route('admin.quizzes.index') }}" class="btn-secondary">Back to list</a>
    </div>
</div>

<div class="bg-white rounded-xl shadow-md border border-slate-100 p-6 mb-6">
    <dl class="grid grid-cols-2 sm:grid-cols-4 gap-4 text-sm">
        <div><dt class="text-slate-500">Questions</dt><dd class="font-medium text-slate-800">{{ $quiz->total_questions }}</dd></div>
        <div><dt class="text-slate-500">Duration</dt><dd class="font-medium text-slate-800">{{ $quiz->duration }} min</dd></div>
        <div><dt class="text-slate-500">Passing %</dt><dd class="font-medium text-slate-800">{{ $quiz->passing_percent }}%</dd></div>
        <div><dt class="text-slate-500">Price</dt><dd class="font-medium text-slate-800">{{ $quiz->is_free ? 'Free' : '₹' . number_format($quiz->price) }}</dd></div>
    </dl>
    @if($quiz->description)
        <p class="mt-4 text-slate-600">{{ $quiz->description }}</p>
    @endif
</div>

<div class="bg-white rounded-xl shadow-md border border-slate-100 p-6">
    <h2 class="font-semibold text-slate-800 mb-4">Questions ({{ $quiz->questions->count() }})</h2>
    @if($quiz->questions->count())
        <ul class="space-y-6">
            @foreach($quiz->questions as $q)
                <li class="border-b border-slate-100 pb-4 last:border-0">
                    <p class="font-medium text-slate-800">{{ $q->question }}</p>
                    <ul class="mt-2 ml-4 space-y-1 text-sm text-slate-600">
                        @foreach($q->options as $opt)
                            <li>{{ $opt->option_key }}. {{ $opt->option_text }} {{ $opt->is_correct ? ' ✓' : '' }}</li>
                        @endforeach
                    </ul>
                </li>
            @endforeach
        </ul>
    @else
        <p class="text-slate-500">No questions added yet.</p>
    @endif
</div>
@endsection
