@extends('layouts.admin')

@section('title', 'Reports & Analytics')
@section('header', 'Reports & Analytics')

@section('content')
<div class="space-y-6">
    {{-- Date Range Filter --}}
    <div class="card">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.reports.index') }}" class="flex items-center gap-4">
                <label class="text-sm font-semibold text-slate-700">Date Range:</label>
                <select name="range" class="input-field min-w-[150px]" onchange="this.form.submit()">
                    <option value="7" {{ $dateRange == 7 ? 'selected' : '' }}>Last 7 days</option>
                    <option value="30" {{ $dateRange == 30 ? 'selected' : '' }}>Last 30 days</option>
                    <option value="90" {{ $dateRange == 90 ? 'selected' : '' }}>Last 90 days</option>
                    <option value="180" {{ $dateRange == 180 ? 'selected' : '' }}>Last 6 months</option>
                    <option value="365" {{ $dateRange == 365 ? 'selected' : '' }}>Last year</option>
                </select>
            </form>
        </div>
    </div>

    {{-- Key Metrics --}}
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="stat-card">
            <p class="stat-label">Total Students</p>
            <p class="stat-value">{{ number_format($stats['total_students']) }}</p>
        </div>
        <div class="stat-card">
            <p class="stat-label">Total Courses</p>
            <p class="stat-value">{{ number_format($stats['active_courses']) }}</p>
            <p class="text-xs text-slate-500 mt-1">{{ $stats['total_courses'] }} total</p>
        </div>
        <div class="stat-card">
            <p class="stat-label">Total Enrollments</p>
            <p class="stat-value">{{ number_format($stats['total_enrollments']) }}</p>
        </div>
        <div class="stat-card">
            <p class="stat-label">Total Revenue</p>
            <p class="stat-value">₹{{ number_format($stats['revenue']) }}</p>
        </div>
    </div>

    {{-- Top Courses --}}
    <div class="card overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50">
            <h2 class="font-bold text-slate-800">Top 10 Courses by Enrollments</h2>
        </div>
        <div class="admin-table-wrap">
            <table class="admin-table w-full">
                <thead>
                    <tr>
                        <th>Rank</th>
                        <th>Course</th>
                        <th>Category</th>
                        <th>Enrollments</th>
                        <th>Avg Progress</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($topCourses as $index => $course)
                        <tr>
                            <td class="font-bold text-slate-600">#{{ $index + 1 }}</td>
                            <td>
                                <a href="{{ route('admin.courses.show', $course) }}" class="font-semibold text-slate-800 hover:text-primary-600">
                                    {{ $course->title }}
                                </a>
                            </td>
                            <td class="text-slate-600">{{ $course->category->name ?? '—' }}</td>
                            <td class="font-semibold">{{ $course->enrollments_count }}</td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <div class="w-20 bg-slate-200 rounded-full h-2">
                                        <div class="bg-primary-600 h-2 rounded-full" style="width: {{ round($course->enrollments_avg_progress_percent ?? 0) }}%"></div>
                                    </div>
                                    <span class="text-sm text-slate-600">{{ round($course->enrollments_avg_progress_percent ?? 0) }}%</span>
                                </div>
                            </td>
                            <td>
                                <a href="{{ route('admin.courses.show', $course) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">View</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    {{-- Course Performance --}}
    <div class="card overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50">
            <h2 class="font-bold text-slate-800">Course Performance Overview</h2>
        </div>
        <div class="admin-table-wrap">
            <table class="admin-table w-full">
                <thead>
                    <tr>
                        <th>Course</th>
                        <th>Enrollments</th>
                        <th>Avg Progress</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($coursePerformance as $course)
                        <tr>
                            <td>
                                <a href="{{ route('admin.courses.show', $course) }}" class="font-semibold text-slate-800 hover:text-primary-600">
                                    {{ $course->title }}
                                </a>
                            </td>
                            <td class="font-semibold">{{ $course->enrollments_count }}</td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <div class="w-24 bg-slate-200 rounded-full h-2">
                                        <div class="bg-primary-600 h-2 rounded-full" style="width: {{ round($course->enrollments_avg_progress_percent ?? 0) }}%"></div>
                                    </div>
                                    <span class="text-sm text-slate-600">{{ round($course->enrollments_avg_progress_percent ?? 0) }}%</span>
                                </div>
                            </td>
                            <td>
                                <span class="badge {{ $course->is_active ? 'badge-success' : 'bg-slate-100 text-slate-600' }}">
                                    {{ $course->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('admin.courses.show', $course) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10 text-slate-500">No courses found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- Student Progress --}}
    <div class="card overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50">
            <h2 class="font-bold text-slate-800">Top Student Progress</h2>
        </div>
        <div class="admin-table-wrap">
            <table class="admin-table w-full">
                <thead>
                    <tr>
                        <th>Student</th>
                        <th>Course</th>
                        <th>Progress</th>
                        <th>Enrolled</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($studentProgress as $enrollment)
                        <tr>
                            <td>
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-primary-100 flex items-center justify-center text-primary-700 font-bold text-sm">
                                        {{ strtoupper(substr($enrollment->user->name, 0, 1)) }}
                                    </div>
                                    <div>
                                        <p class="font-semibold text-slate-800">{{ $enrollment->user->name }}</p>
                                        <p class="text-xs text-slate-500">{{ $enrollment->user->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="text-slate-600">{{ $enrollment->course->title }}</td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <div class="w-24 bg-slate-200 rounded-full h-2">
                                        <div class="bg-primary-600 h-2 rounded-full" style="width: {{ $enrollment->progress_percent }}%"></div>
                                    </div>
                                    <span class="text-sm font-semibold text-slate-700">{{ $enrollment->progress_percent }}%</span>
                                </div>
                            </td>
                            <td class="text-slate-600">{{ $enrollment->enrolled_at->format('M d, Y') }}</td>
                            <td>
                                <a href="{{ route('admin.enrollments.show', $enrollment) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10 text-slate-500">No enrollments found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
