@extends('layouts.admin')

@section('title', 'Edit Testimonial')
@section('header', 'Edit Testimonial')

@section('content')
<div class="max-w-2xl">
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.testimonials.update', $testimonial) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="space-y-6">
                    <div>
                        <label for="name" class="block text-sm font-semibold text-slate-700 mb-1.5">Name *</label>
                        <input type="text" id="name" name="name" value="{{ old('name', $testimonial->name) }}" required class="input-field">
                        @error('name')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="role" class="block text-sm font-semibold text-slate-700 mb-1.5">Role/Designation *</label>
                        <input type="text" id="role" name="role" value="{{ old('role', $testimonial->role) }}" required class="input-field">
                        @error('role')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="program" class="block text-sm font-semibold text-slate-700 mb-1.5">Program/Course</label>
                        <input type="text" id="program" name="program" value="{{ old('program', $testimonial->program) }}" class="input-field">
                        @error('program')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="quote" class="block text-sm font-semibold text-slate-700 mb-1.5">Testimonial Quote *</label>
                        <textarea id="quote" name="quote" rows="4" required class="input-field">{{ old('quote', $testimonial->quote) }}</textarea>
                        @error('quote')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="story" class="block text-sm font-semibold text-slate-700 mb-1.5">Full Story (Optional)</label>
                        <textarea id="story" name="story" rows="6" class="input-field">{{ old('story', $testimonial->story) }}</textarea>
                        @error('story')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="linkedin_url" class="block text-sm font-semibold text-slate-700 mb-1.5">LinkedIn URL</label>
                        <input type="url" id="linkedin_url" name="linkedin_url" value="{{ old('linkedin_url', $testimonial->linkedin_url) }}" class="input-field">
                        @error('linkedin_url')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label for="sort_order" class="block text-sm font-semibold text-slate-700 mb-1.5">Sort Order</label>
                        <input type="number" id="sort_order" name="sort_order" value="{{ old('sort_order', $testimonial->sort_order) }}" min="0" class="input-field">
                        @error('sort_order')<p class="text-red-600 text-sm mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div class="flex items-center gap-2">
                        <input type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $testimonial->is_active) ? 'checked' : '' }} class="rounded border-slate-300 text-primary-600 focus:ring-primary-500">
                        <label for="is_active" class="text-sm font-semibold text-slate-700">Active</label>
                    </div>
                    <div class="flex items-center gap-4 pt-4">
                        <button type="submit" class="btn-primary">Update Testimonial</button>
                        <a href="{{ route('admin.testimonials.index') }}" class="btn-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
