@extends('layouts.admin')

@section('title', 'Testimonials')
@section('header', 'Testimonials Management')

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-xl font-bold text-slate-900">All Testimonials</h2>
            <p class="text-slate-600 mt-1">Manage student testimonials and reviews</p>
        </div>
        <a href="{{ route('admin.testimonials.create') }}" class="btn-primary">Add Testimonial</a>
    </div>

    {{-- Filters --}}
    <div class="card">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.testimonials.index') }}" class="flex flex-wrap gap-4">
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search testimonials..." class="input-field flex-1 min-w-[200px]">
                <select name="status" class="input-field min-w-[150px]">
                    <option value="">All Status</option>
                    <option value="1" {{ request('status') === '1' ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ request('status') === '0' ? 'selected' : '' }}>Inactive</option>
                </select>
                <button type="submit" class="btn-primary">Filter</button>
                @if(request()->hasAny(['search', 'status']))
                    <a href="{{ route('admin.testimonials.index') }}" class="btn-secondary">Clear</a>
                @endif
            </form>
        </div>
    </div>

    {{-- Testimonials Table --}}
    <div class="card overflow-hidden">
        <div class="admin-table-wrap">
            <table class="admin-table w-full">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Role</th>
                        <th>Program</th>
                        <th>Quote</th>
                        <th>Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($testimonials as $testimonial)
                        <tr>
                            <td>
                                <div class="flex items-center gap-3">
                                    @if($testimonial->avatar)
                                        <img src="{{ $testimonial->avatar }}" alt="{{ $testimonial->name }}" class="w-10 h-10 rounded-full">
                                    @else
                                        <div class="w-10 h-10 rounded-full bg-primary-100 flex items-center justify-center text-primary-700 font-bold">
                                            {{ strtoupper(substr($testimonial->name, 0, 1)) }}
                                        </div>
                                    @endif
                                    <span class="font-semibold text-slate-800">{{ $testimonial->name }}</span>
                                </div>
                            </td>
                            <td class="text-slate-600">{{ $testimonial->role }}</td>
                            <td class="text-slate-600">{{ $testimonial->program ?? '—' }}</td>
                            <td class="text-slate-600 max-w-xs truncate">{{ \Illuminate\Support\Str::limit($testimonial->quote, 60) }}</td>
                            <td class="text-slate-600">{{ $testimonial->sort_order }}</td>
                            <td>
                                <span class="badge {{ $testimonial->is_active ? 'badge-success' : 'bg-slate-100 text-slate-600' }}">
                                    {{ $testimonial->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('admin.testimonials.edit', $testimonial) }}" class="text-sm text-primary-600 hover:text-primary-700 font-semibold">Edit</a>
                                    <form action="{{ route('admin.testimonials.destroy', $testimonial) }}" method="POST" onsubmit="return confirm('Are you sure?')" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-sm text-red-600 hover:text-red-700 font-semibold">Delete</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-10 text-slate-500">No testimonials found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($testimonials->hasPages())
            <div class="px-6 py-4 border-t border-slate-100">
                {{ $testimonials->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
