@extends('layouts.admin')

@section('title', 'Users')
@section('header', 'Users')

@section('content')
<form action="{{ route('admin.users.index') }}" method="GET" class="flex flex-col sm:flex-row gap-4 mb-6">
    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by name or email..." class="input-field sm:max-w-xs py-2.5">
    <select name="role" class="input-field sm:w-40 py-2.5">
        <option value="">All roles</option>
        <option value="student" {{ request('role') === 'student' ? 'selected' : '' }}>Student</option>
        <option value="admin" {{ request('role') === 'admin' ? 'selected' : '' }}>Admin</option>
        <option value="instructor" {{ request('role') === 'instructor' ? 'selected' : '' }}>Instructor</option>
    </select>
    <button type="submit" class="btn-primary">Filter</button>
</form>

<div class="admin-table-wrap">
    <div class="overflow-x-auto">
        <table class="admin-table min-w-full">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Role</th>
                    <th>Joined</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($users as $user)
                    <tr>
                        <td>
                            <a href="{{ route('admin.users.show', $user) }}" class="flex items-center gap-3 hover:opacity-90">
                                <div class="w-11 h-11 rounded-xl bg-primary-100 flex items-center justify-center text-primary-700 font-bold shrink-0">{{ strtoupper(substr($user->name, 0, 1)) }}</div>
                                <div>
                                    <p class="font-semibold text-slate-800">{{ $user->name }}</p>
                                    <p class="text-sm text-slate-500">{{ $user->email }}</p>
                                </div>
                            </a>
                        </td>
                        <td>
                            <span class="text-xs font-semibold px-2.5 py-1 rounded-lg {{ $user->role === 'admin' ? 'bg-amber-100 text-amber-800' : ($user->role === 'instructor' ? 'bg-blue-100 text-blue-800' : 'bg-slate-100 text-slate-600') }}">{{ $user->role }}</span>
                        </td>
                        <td class="text-slate-600">{{ $user->created_at->format('M d, Y') }}</td>
                        <td class="text-right">
                            <a href="{{ route('admin.users.show', $user) }}" class="font-semibold text-primary-600 hover:text-primary-700 text-sm">View</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="px-6 py-14 text-center text-slate-500">No users found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($users->hasPages())
        <div class="px-6 py-4 border-t border-slate-200 bg-slate-50/50">{{ $users->links() }}</div>
    @endif
</div>
@endsection
