@extends('layouts.admin')

@section('title', $user->name)
@section('header', $user->name)

@section('content')
<div class="max-w-3xl space-y-6">
    <div class="bg-white rounded-xl shadow-md border border-slate-100 p-6">
        <div class="flex items-center gap-4 mb-6">
            <div class="w-16 h-16 rounded-full bg-teal-100 flex items-center justify-center text-teal-700 text-2xl font-bold">{{ strtoupper(substr($user->name, 0, 1)) }}</div>
            <div>
                <h2 class="text-xl font-semibold text-slate-800">{{ $user->name }}</h2>
                <p class="text-slate-600">{{ $user->email }}</p>
                <span class="text-xs px-2 py-1 rounded-full mt-2 inline-block {{ $user->role === 'admin' ? 'bg-amber-100 text-amber-800' : 'bg-slate-100 text-slate-600' }}">{{ $user->role }}</span>
            </div>
        </div>
        <dl class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
            <div><dt class="text-slate-500">Phone</dt><dd class="font-medium text-slate-800">{{ $user->phone ?? '—' }}</dd></div>
            <div><dt class="text-slate-500">Joined</dt><dd class="font-medium text-slate-800">{{ $user->created_at->format('M d, Y') }}</dd></div>
            <div><dt class="text-slate-500">Course enrollments</dt><dd class="font-medium text-slate-800">{{ $user->enrollments_count ?? 0 }}</dd></div>
            <div><dt class="text-slate-500">Quiz attempts</dt><dd class="font-medium text-slate-800">{{ $user->quiz_attempts_count ?? 0 }}</dd></div>
        </dl>
    </div>
    <a href="{{ route('admin.users.index') }}" class="btn-secondary inline-block">Back to users</a>
</div>
@endsection
