<x-app-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Courses</h1>
        <p class="text-slate-600 mt-0.5">
            @if(request('type') === 'free')
                Free courses to get started.
            @elseif(request('category'))
                {{ $categories->firstWhere('slug', request('category'))?->name ?? 'Programs' }}
            @else
                Browse all programs and certifications.
            @endif
        </p>
    </x-slot>

    <div class="space-y-8">
        @if($courses->count())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($courses as $course)
                    <a href="{{ route('courses.show', $course) }}" class="course-card group">
                        @if($course->thumbnail)
                            <img src="{{ asset('storage/' . $course->thumbnail) }}" alt="{{ $course->title }}" class="w-full h-44 object-cover group-hover:scale-[1.02] transition duration-300">
                        @else
                            <div class="w-full h-44 bg-gradient-to-br from-slate-100 to-slate-200 flex items-center justify-center">
                                <svg class="w-16 h-16 text-slate-400 group-hover:text-primary-400 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                            </div>
                        @endif
                        <div class="p-6">
                            <div class="flex items-center gap-2 flex-wrap">
                                <span class="text-xs font-semibold text-primary-600">{{ $course->category->name ?? 'Course' }}</span>
                                @if($course->type === 'free')
                                    <span class="badge-success">Free</span>
                                @else
                                    <span class="badge-warning">₹{{ number_format($course->price) }}</span>
                                @endif
                            </div>
                            <h3 class="font-bold text-slate-900 mt-2 line-clamp-2 group-hover:text-primary-600 transition-colors">{{ $course->title }}</h3>
                            <p class="text-sm text-slate-500 mt-2 line-clamp-2">{{ Str::limit($course->description, 80) }}</p>
                            <div class="mt-4 flex justify-between items-center text-sm text-slate-500">
                                <span>{{ $course->total_lessons }} lessons</span>
                                @if($course->total_duration)
                                    <span>{{ round($course->total_duration / 60) }} hrs</span>
                                @endif
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
            @if($courses->hasPages())
                <div class="flex justify-center pt-4">{{ $courses->links() }}</div>
            @endif
        @else
            <div class="card overflow-hidden">
                <div class="card-body text-center py-16">
                    <p class="text-slate-500 text-lg">No courses available yet.</p>
                    <a href="{{ route('home') }}" class="inline-block mt-4 text-primary-600 font-semibold hover:underline">Back to home</a>
                </div>
            </div>
        @endif
    </div>
</x-app-layout>
