<x-app-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">My courses</h1>
        <p class="text-slate-600 mt-0.5">Your enrollments and progress.</p>
    </x-slot>

    <div class="space-y-6">
        @if($enrollments->count())
            <div class="space-y-4">
                @foreach($enrollments as $enrollment)
                    @if($enrollment->course && $enrollment->course->slug)
                        <a href="{{ route('courses.learn', $enrollment->course) }}" class="card block overflow-hidden group">
                        <div class="p-6 flex flex-col md:flex-row md:items-center gap-6">
                            <div class="flex-1 min-w-0">
                                <span class="text-sm font-semibold text-primary-600">{{ $enrollment->course->category->name ?? 'Course' }}</span>
                                <h3 class="font-bold text-slate-900 mt-1 group-hover:text-primary-600 transition-colors">{{ $enrollment->course->title }}</h3>
                                <p class="text-sm text-slate-500 mt-1">Enrolled {{ $enrollment->enrolled_at->format('M d, Y') }}</p>
                            </div>
                            <div class="md:w-56 shrink-0">
                                <div class="flex justify-between text-sm mb-2">
                                    <span class="text-slate-500">Progress</span>
                                    <span class="font-semibold text-slate-700">{{ $enrollment->progress_percent }}%</span>
                                </div>
                                <div class="w-full bg-slate-200 rounded-full h-2.5 overflow-hidden">
                                    <div class="bg-primary-500 h-2.5 rounded-full transition-all duration-500" style="width: {{ $enrollment->progress_percent }}%"></div>
                                </div>
                            </div>
                        </div>
                        </a>
                    @endif
                @endforeach
            </div>
            @if($enrollments->hasPages())
                <div class="flex justify-center pt-4">{{ $enrollments->links() }}</div>
            @endif
        @else
            <div class="card overflow-hidden">
                <div class="card-body text-center py-16">
                    <p class="text-slate-500 text-lg">You haven’t enrolled in any courses yet.</p>
                    <a href="{{ route('courses.index') }}" class="btn-primary inline-flex mt-6">Browse courses</a>
                </div>
            </div>
        @endif
    </div>
</x-app-layout>
