<x-app-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Dashboard</h1>
        <p class="text-slate-600 mt-0.5">Welcome back. Here’s your learning overview.</p>
    </x-slot>

    <div class="space-y-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="stat-card">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="stat-label">Enrolled courses</p>
                        <p class="stat-value">{{ $stats['courses'] ?? 0 }}</p>
                    </div>
                    <div class="w-14 h-14 rounded-2xl bg-primary-100 flex items-center justify-center">
                        <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                    </div>
                </div>
            </div>
            <div class="stat-card">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="stat-label">Quizzes attempted</p>
                        <p class="stat-value">{{ $stats['quizzes'] ?? 0 }}</p>
                    </div>
                    <div class="w-14 h-14 rounded-2xl bg-blue-100 flex items-center justify-center">
                        <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/></svg>
                    </div>
                </div>
            </div>
            <div class="stat-card">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="stat-label">Overall progress</p>
                        <p class="stat-value">{{ $stats['progress'] ?? 0 }}%</p>
                    </div>
                    <div class="w-14 h-14 rounded-2xl bg-amber-100 flex items-center justify-center">
                        <svg class="w-7 h-7 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/></svg>
                    </div>
                </div>
            </div>
        </div>

        <div class="card overflow-hidden">
            <div class="card-body">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-lg font-bold text-slate-900">My courses</h2>
                    <a href="{{ route('courses.my-courses') }}" class="text-sm font-semibold text-primary-600 hover:text-primary-700">View all →</a>
                </div>
                @if(isset($enrollments) && $enrollments->count())
                    <div class="space-y-4">
                        @foreach($enrollments as $e)
                            @if($e->course && $e->course->slug)
                                <a href="{{ route('courses.show', $e->course) }}" class="block p-4 rounded-xl border border-slate-100 hover:border-primary-100 hover:bg-slate-50/50 transition">
                                    <div class="flex justify-between items-center">
                                        <span class="font-semibold text-slate-800">{{ $e->course->title }}</span>
                                        <span class="text-sm font-medium text-slate-500">{{ $e->progress_percent }}%</span>
                                    </div>
                                    <div class="w-full bg-slate-200 rounded-full h-2.5 mt-3 overflow-hidden">
                                        <div class="bg-primary-500 h-2.5 rounded-full transition-all duration-500" style="width: {{ $e->progress_percent }}%"></div>
                                    </div>
                                </a>
                            @endif
                        @endforeach
                    </div>
                @else
                    <p class="text-slate-500 py-4">No courses enrolled yet.</p>
                    <a href="{{ route('courses.index') }}" class="btn-primary inline-flex mt-2">Browse courses</a>
                @endif
            </div>
        </div>

        @if(isset($recentAttempts) && $recentAttempts->count())
        <div class="card overflow-hidden">
            <div class="card-body">
                <h2 class="text-lg font-bold text-slate-900 mb-4">Recent quiz results</h2>
                <div class="space-y-3">
                    @foreach($recentAttempts as $a)
                        <div class="flex justify-between items-center p-4 rounded-xl border border-slate-100 bg-slate-50/50">
                            <span class="font-medium text-slate-800">{{ $a->quiz->title }}</span>
                            <span class="font-semibold {{ $a->percent >= $a->quiz->passing_percent ? 'text-emerald-600' : 'text-red-600' }}">
                                {{ $a->percent }}% {{ $a->percent >= $a->quiz->passing_percent ? 'Passed' : 'Try again' }}
                            </span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <div class="card overflow-hidden">
            <div class="card-body">
                <h2 class="text-lg font-bold text-slate-900 mb-4">Quick actions</h2>
                <div class="flex flex-wrap gap-3">
                    <a href="{{ route('courses.index') }}" class="btn-primary">Browse courses</a>
                    <a href="{{ route('quizzes.index') }}" class="inline-flex items-center justify-center px-5 py-2.5 rounded-xl font-semibold text-white bg-emerald-600 hover:bg-emerald-700 transition shadow-sm">Take a quiz</a>
                    <a href="{{ route('courses.my-courses') }}" class="btn-secondary">My courses</a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
