<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>@yield('title', config('app.name'))</title>
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700,800&display=swap" rel="stylesheet" />
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-slate-800 antialiased">
        <div class="min-h-screen flex flex-col sm:justify-center items-center py-12 px-4 bg-gradient-to-br from-slate-50 via-white to-primary-50/20">
            <a href="{{ route('home') }}" class="text-2xl font-bold text-slate-800 tracking-tight">LMS <span class="text-primary-600">Portal</span></a>
            <div class="w-full sm:max-w-md mt-8 p-8 bg-white rounded-2xl shadow-soft-lg border border-slate-100">
                {{ $slot }}
            </div>
        </div>
    </body>
</html>
