@php
    $openModal = session('open_auth_modal', false);
    $modalTab = session('auth_modal_tab', 'login');
@endphp
@php
    $startOnForm = $openModal && in_array($modalTab, ['login', 'register']);
@endphp
<div
    x-data="{
        open: {{ $openModal ? 'true' : 'false' }},
        step: '{{ $startOnForm ? 'form' : 'welcome' }}',
        tab: '{{ $modalTab ?: 'login' }}',
        intendedTab: '{{ $modalTab ?: 'login' }}',
        phone: '',
        close() { this.open = false; },
        showForm() { this.step = 'form'; this.tab = this.intendedTab; },
        showWelcome() { this.step = 'welcome'; }
    }"
    x-on:open-auth-modal.window="
        open = true;
        intendedTab = ($event.detail && $event.detail.tab) ? $event.detail.tab : 'login';
        tab = intendedTab;
        step = 'welcome';
    "
    x-effect="
        if (open) {
            document.body.style.overflow = 'hidden';
            document.body.style.paddingRight = (window.innerWidth - document.documentElement.clientWidth) + 'px';
        } else {
            document.body.style.overflow = '';
            document.body.style.paddingRight = '0';
        }
    "
    x-on:keydown.escape.window="if (open) close()"
    x-show="open"
    x-cloak
    class="fixed inset-0 z-[100] flex items-center justify-center p-4 overflow-y-auto"
    style="min-height: 100dvh;"
    role="dialog"
    aria-modal="true"
    aria-label="Sign in or sign up"
>
    {{-- Backdrop --}}
    <div
        x-show="open"
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="fixed inset-0 bg-slate-900/70 backdrop-blur-sm"
        @click="close()"
        aria-hidden="true"
    ></div>

    {{-- Modal: two columns, 8px grid, professional shadow --}}
    <div
        x-show="open"
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0 scale-[0.98]"
        x-transition:enter-end="opacity-100 scale-100"
        x-transition:leave="ease-in duration-200"
        class="relative w-full max-w-lg sm:max-w-2xl bg-white rounded-3xl overflow-hidden my-8 flex flex-col sm:flex-row sm:max-h-[88vh] border border-slate-200/80"
        style="box-shadow: 0 25px 50px -12px rgba(0,0,0,0.2), 0 0 0 1px rgba(0,0,0,0.05);"
        @click.stop
    >
        {{-- Left: illustration + pills (subtle bg for depth) --}}
        <div class="hidden sm:flex sm:w-[44%] flex-shrink-0 bg-gradient-to-br from-slate-50 to-white flex-col justify-center items-center p-10">
            <div class="w-full max-w-[160px] mx-auto">
                <svg viewBox="0 0 200 220" class="w-full h-auto" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <ellipse cx="100" cy="165" rx="32" ry="38" fill="#f1f5f9"/>
                    <path d="M68 165 L68 95 Q68 70 100 55 Q132 70 132 95 L132 165" fill="#dc2626"/>
                    <path d="M76 95 L76 65 Q100 45 124 65 L124 95" fill="#fef2f2"/>
                    <path d="M68 140 L50 165 L68 165 Z" fill="#dc2626"/>
                    <path d="M132 140 L150 165 L132 165 Z" fill="#dc2626"/>
                    <circle cx="100" cy="115" r="22" fill="#fef9c3"/>
                    <circle cx="100" cy="112" r="10" fill="#fde047"/>
                    <path d="M92 98 Q100 88 108 98" stroke="#a16207" stroke-width="1.5" fill="none" stroke-linecap="round"/>
                    <path d="M85 125 L95 118 L100 125 L105 118 L115 125" stroke="#a16207" stroke-width="1.2" fill="none" stroke-linecap="round"/>
                    <path d="M88 200 Q100 230 112 200 Q100 215 88 200" fill="#ea580c"/>
                    <path d="M92 198 Q100 218 108 198 Q100 208 92 198" fill="#f59e0b"/>
                </svg>
            </div>
            <div class="flex flex-wrap justify-center gap-3 mt-8 w-full">
                <span class="inline-flex items-center gap-2 px-3.5 py-2 rounded-full bg-white/90 border border-slate-200/80 text-slate-700 text-xs font-semibold shadow-sm">
                    <svg class="w-4 h-4 text-violet-500 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"/></svg>
                    Career Switch
                </span>
                <span class="inline-flex items-center gap-2 px-3.5 py-2 rounded-full bg-white/90 border border-slate-200/80 text-slate-700 text-xs font-semibold shadow-sm">
                    <svg class="w-4 h-4 text-blue-500 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8v8m-8-8h8m-8 0V7m0 8v8"/></svg>
                    Promotion
                </span>
                <span class="inline-flex items-center gap-2 px-3.5 py-2 rounded-full bg-white/90 border border-slate-200/80 text-slate-700 text-xs font-semibold shadow-sm">
                    <svg class="w-4 h-4 text-emerald-500 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 17h8m0 0V9m0 8l-8-8-4 4V3"/></svg>
                    Salary Hike
                </span>
            </div>
        </div>

        {{-- Right: form content (scrollable) --}}
        <div class="flex-1 flex flex-col min-w-0 bg-white overflow-y-auto">
            {{-- Welcome step --}}
            <div
                x-show="step === 'welcome'"
                x-transition:enter="ease-out duration-200"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in duration-150"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                x-cloak
                class="p-6 sm:p-8 flex flex-col"
            >
                <div class="flex items-center justify-between gap-2 mb-8">
                    <button type="button" @click="close()" class="p-2.5 -ml-1 rounded-xl text-slate-500 hover:bg-slate-100 hover:text-slate-700 transition shrink-0" aria-label="Close">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
                    </button>
                    <button type="button" @click="close()" class="p-2.5 rounded-xl text-slate-500 hover:bg-slate-100 hover:text-slate-700 transition shrink-0" aria-label="Close">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                    </button>
                </div>
                <h2 class="text-2xl font-bold text-slate-900 tracking-tight mb-2">Welcome back</h2>
                <p class="text-slate-600 text-sm mb-8">Sign up or log in to continue.</p>

                <div class="flex rounded-xl border border-slate-300 bg-white overflow-hidden focus-within:ring-2 focus-within:ring-primary-500/25 focus-within:border-primary-500 transition-shadow duration-200">
                    <div class="flex items-center gap-2 pl-4 pr-3 py-3 border-r border-slate-200 bg-slate-50/80 shrink-0 min-h-[48px]">
                        <span class="text-lg leading-none" aria-hidden="true">🇮🇳</span>
                        <span class="text-sm font-semibold text-slate-700">+91</span>
                        <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </div>
                    <input type="tel" x-model="phone" placeholder="Phone number" class="flex-1 min-w-0 py-3 px-4 text-slate-900 placeholder-slate-400 text-sm border-0 bg-transparent focus:ring-0" inputmode="numeric" pattern="[0-9]*" aria-label="Phone number">
                </div>

                <p class="text-center text-slate-500 text-sm my-5">or</p>

                <button type="button" @click="showForm()" class="w-full min-h-[48px] py-3 rounded-xl font-semibold text-slate-800 bg-white border border-slate-300 hover:bg-slate-50 hover:border-slate-400 focus:ring-2 focus:ring-primary-500/25 focus:ring-offset-2 focus:border-primary-500 transition-all duration-200 text-sm">
                    Continue with Email
                </button>

                <button type="button" :disabled="!(phone || '').trim().length" :class="(phone || '').trim().length ? 'bg-primary-600 hover:bg-primary-700 text-white border-primary-600' : 'bg-slate-100 text-slate-400 border-slate-200 cursor-not-allowed'" class="w-full min-h-[48px] py-3 rounded-xl font-semibold border focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2 transition-all duration-200 text-sm mt-4">
                    Continue
                </button>

                <p class="mt-8 pt-6 border-t border-slate-100 text-center">
                    <a href="{{ route('admin.login') }}" @click="close()" class="text-xs text-slate-400 hover:text-slate-600 transition">Administrator? Sign in here</a>
                </p>
            </div>

            {{-- Form step: Login / Sign up --}}
            <div
                x-show="step === 'form'"
                x-transition:enter="ease-out duration-200"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in duration-150"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                x-cloak
                class="p-6 sm:p-8 flex flex-col"
            >
                <div class="flex items-center justify-between gap-2 mb-6">
                    <div class="flex items-center gap-2 min-w-0">
                        <button type="button" @click="showWelcome()" class="p-2.5 -ml-1 rounded-xl text-slate-500 hover:bg-slate-100 hover:text-slate-700 transition shrink-0" aria-label="Back">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
                        </button>
                        <h2 class="text-xl font-bold text-slate-900 tracking-tight truncate">Sign in or sign up</h2>
                    </div>
                    <button type="button" @click="close()" class="p-2.5 rounded-xl text-slate-500 hover:bg-slate-100 hover:text-slate-700 transition shrink-0" aria-label="Close">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                    </button>
                </div>

                <div class="flex rounded-xl bg-slate-100 p-1.5 mb-6" role="tablist">
                    <button type="button" role="tab" :aria-selected="tab === 'login'" @click="tab = 'login'" :class="tab === 'login' ? 'bg-white text-slate-900 shadow-sm font-semibold' : 'text-slate-600 hover:text-slate-800'" class="flex-1 py-3 rounded-lg text-sm transition duration-200">Login</button>
                    <button type="button" role="tab" :aria-selected="tab === 'register'" @click="tab = 'register'" :class="tab === 'register' ? 'bg-white text-slate-900 shadow-sm font-semibold' : 'text-slate-600 hover:text-slate-800'" class="flex-1 py-3 rounded-lg text-sm transition duration-200">Sign up</button>
                </div>

                {{-- Login --}}
                <div x-show="tab === 'login'" x-cloak class="space-y-5">
                    @if ($errors->get('email') && session('auth_modal_tab') === 'login')
                        <div class="p-4 rounded-xl bg-red-50 border border-red-100 text-red-700 text-sm" role="alert">{{ $errors->first('email') }}</div>
                    @endif
                    <form method="POST" action="{{ route('login') }}" class="space-y-5">
                        @csrf
                        <div>
                            <label for="modal_email" class="block text-sm font-semibold text-slate-700 mb-1.5">Email</label>
                            <input id="modal_email" type="email" name="email" value="{{ old('email') }}" required autocomplete="username" placeholder="you@example.com" class="input-field py-3 px-4 min-h-[48px] text-sm">
                        </div>
                        <div>
                            <label for="modal_password" class="block text-sm font-semibold text-slate-700 mb-1.5">Password</label>
                            <input id="modal_password" type="password" name="password" required autocomplete="current-password" placeholder="••••••••" class="input-field py-3 px-4 min-h-[48px] text-sm">
                        </div>
                        <div class="flex flex-wrap items-center gap-x-6 gap-y-2">
                            <label class="inline-flex items-center gap-2.5 cursor-pointer select-none">
                                <input type="checkbox" name="remember" class="rounded border-slate-300 text-primary-600 focus:ring-primary-500 w-5 h-5 shrink-0">
                                <span class="text-sm text-slate-600">Remember me</span>
                            </label>
                            @if (Route::has('password.request'))
                                <a href="{{ route('password.request') }}" @click="close()" class="text-sm font-semibold text-primary-600 hover:text-primary-700 hover:underline underline-offset-2">Forgot password?</a>
                            @endif
                        </div>
                        <button type="submit" class="btn-primary w-full min-h-[48px] py-3 text-sm">Continue</button>
                    </form>
                </div>

                {{-- Register --}}
                <div x-show="tab === 'register'" x-cloak class="space-y-5">
                    @if ($errors->any() && session('auth_modal_tab') === 'register')
                        <div class="p-4 rounded-xl bg-red-50 border border-red-100 text-red-700 text-sm space-y-1" role="alert">
                            @foreach ($errors->all() as $err) <p>{{ $err }}</p> @endforeach
                        </div>
                    @endif
                    <form method="POST" action="{{ route('register') }}" class="space-y-5">
                        @csrf
                        <div>
                            <label for="modal_name" class="block text-sm font-semibold text-slate-700 mb-1.5">Name</label>
                            <input id="modal_name" type="text" name="name" value="{{ old('name') }}" required autocomplete="name" placeholder="Your name" class="input-field py-3 px-4 min-h-[48px] text-sm">
                        </div>
                        <div>
                            <label for="modal_reg_email" class="block text-sm font-semibold text-slate-700 mb-1.5">Email</label>
                            <input id="modal_reg_email" type="email" name="email" value="{{ old('email') }}" required autocomplete="username" placeholder="you@example.com" class="input-field py-3 px-4 min-h-[48px] text-sm">
                        </div>
                        <div>
                            <label for="modal_reg_password" class="block text-sm font-semibold text-slate-700 mb-1.5">Password</label>
                            <input id="modal_reg_password" type="password" name="password" required autocomplete="new-password" placeholder="At least 8 characters" class="input-field py-3 px-4 min-h-[48px] text-sm">
                        </div>
                        <div>
                            <label for="modal_password_confirmation" class="block text-sm font-semibold text-slate-700 mb-1.5">Confirm password</label>
                            <input id="modal_password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password" placeholder="Same as above" class="input-field py-3 px-4 min-h-[48px] text-sm">
                        </div>
                        <button type="submit" class="btn-primary w-full min-h-[48px] py-3 text-sm">Create account</button>
                    </form>
                </div>

                <p class="mt-8 pt-6 border-t border-slate-100 text-center">
                    <a href="{{ route('admin.login') }}" @click="close()" class="text-xs text-slate-400 hover:text-slate-600 transition">Administrator? Sign in here</a>
                </p>
            </div>
        </div>
    </div>
</div>
