<footer class="bg-slate-900 text-slate-400">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
            <div class="lg:col-span-1">
                <p class="text-white font-bold text-xl tracking-tight">LMS Portal</p>
                <p class="mt-4 text-sm leading-relaxed">Building careers of tomorrow. Structured learning for competitive exams, board exams, and professional certifications.</p>
            </div>
            <div>
                <p class="text-white font-semibold text-sm uppercase tracking-wider mb-4">Programs</p>
                <ul class="space-y-3 text-sm">
                    @foreach(($categories ?? collect())->take(6) as $c)
                        <li><a href="{{ route('courses.index', ['category' => $c->slug]) }}" class="hover:text-white transition">{{ $c->name }}</a></li>
                    @endforeach
                    <li><a href="{{ route('courses.index') }}" class="hover:text-white transition font-medium">All courses</a></li>
                </ul>
            </div>
            <div>
                <p class="text-white font-semibold text-sm uppercase tracking-wider mb-4">Support</p>
                <ul class="space-y-3 text-sm">
                    <li><a href="{{ route('home') }}#support" class="hover:text-white transition">Contact</a></li>
                    <li><a href="{{ route('testimonials') }}" class="hover:text-white transition">Testimonials</a></li>
                    <li><a href="{{ route('refer.index') }}" class="hover:text-white transition">Refer & Earn</a></li>
                </ul>
            </div>
            <div>
                <p class="text-white font-semibold text-sm uppercase tracking-wider mb-4">Contact</p>
                <p class="text-sm">support@lmsportal.com</p>
                <p class="text-sm mt-1">+1 (000) 000-0000</p>
            </div>
        </div>
        <div class="border-t border-slate-700/80 mt-12 pt-8 flex flex-col sm:flex-row justify-between items-center gap-4">
            <p class="text-sm text-slate-500">&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
            <div class="flex gap-8 text-sm">
                <a href="#" class="hover:text-white transition">Terms</a>
                <a href="#" class="hover:text-white transition">Privacy</a>
            </div>
        </div>
    </div>
</footer>
