<x-app-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Quizzes</h1>
        <p class="text-slate-600 mt-0.5">Practice and mock tests to check your progress.</p>
    </x-slot>

    <div class="space-y-8">
        @if($quizzes->count())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($quizzes as $quiz)
                    <a href="{{ route('quizzes.show', $quiz) }}" class="course-card group">
                        <div class="p-6">
                            <span class="text-xs font-semibold text-primary-600 uppercase tracking-wide">{{ $quiz->category->name ?? 'Quiz' }}</span>
                            <h3 class="font-bold text-slate-900 mt-2 line-clamp-2 group-hover:text-primary-600 transition-colors">{{ $quiz->title }}</h3>
                            <p class="text-sm text-slate-500 mt-2 line-clamp-2">{{ Str::limit($quiz->description, 80) }}</p>
                            <div class="mt-4 flex flex-wrap gap-2 items-center">
                                <span class="text-xs font-semibold px-2.5 py-1 rounded-lg bg-slate-100 text-slate-700">{{ $quiz->type }}</span>
                                <span class="text-sm text-slate-500">{{ $quiz->total_questions }} Q · {{ $quiz->duration }} min</span>
                                @if($quiz->is_free)
                                    <span class="badge-success ml-auto">Free</span>
                                @else
                                    <span class="badge-warning ml-auto">₹{{ number_format($quiz->price) }}</span>
                                @endif
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
            @if($quizzes->hasPages())
                <div class="flex justify-center pt-4">{{ $quizzes->links() }}</div>
            @endif
        @else
            <div class="card overflow-hidden">
                <div class="card-body text-center py-16">
                    <p class="text-slate-500 text-lg">No quizzes available yet.</p>
                </div>
            </div>
        @endif
    </div>
</x-app-layout>
