<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ $quiz->title }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <p class="text-gray-600 mb-6">{{ $quiz->description }}</p>
                <div class="flex flex-wrap gap-4 mb-6">
                    <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded text-sm">{{ $quiz->type }}</span>
                    <span class="text-gray-600">{{ $quiz->total_questions }} Questions</span>
                    <span class="text-gray-600">{{ $quiz->duration }} minutes</span>
                    <span class="text-gray-600">Pass: {{ $quiz->passing_percent }}%</span>
                    <span class="{{ $quiz->is_free ? 'text-green-600' : 'text-blue-600' }} font-medium">
                        {{ $quiz->is_free ? 'Free' : '₹' . number_format($quiz->price) }}
                    </span>
                </div>
                <p class="text-sm text-gray-500 mb-6">
                    Use the API to attempt this quiz: POST /api/quizzes/{{ $quiz->id }}/start with JWT token
                </p>
                <a href="{{ route('quizzes.index') }}" class="inline-block px-6 py-2 bg-gray-200 text-gray-800 rounded hover:bg-gray-300">Back to Quizzes</a>
            </div>
        </div>
    </div>
</x-app-layout>
