<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Refer & Earn – {{ config('app.name') }}</title>
    <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700&display=swap" rel="stylesheet" />
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased bg-white text-slate-800">
    <div class="min-h-screen flex flex-col">
        @include('partials.header-upgrad')
        <main class="flex-1 max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <h1 class="text-3xl font-bold text-slate-900 mb-2">Refer & Earn</h1>
            <p class="text-slate-600 mb-8">Share your referral link with friends. When they sign up and enroll, you can earn rewards (configure rewards in admin).</p>

            @if(session('success'))
                <div class="mb-6 p-4 rounded-lg bg-primary-50 text-primary-800 border border-primary-200">{{ session('success') }}</div>
            @endif

            @auth
                <div class="card">
                    <div class="card-body">
                        <h2 class="font-semibold text-slate-900 mb-2">Create a referral code</h2>
                        <form action="{{ route('refer.store') }}" method="POST" class="flex gap-2">
                            @csrf
                            <input type="email" name="email" placeholder="Friend's email (optional)" class="input-field flex-1">
                            <button type="submit" class="btn-primary">Get code</button>
                        </form>
                    </div>
                </div>
                @if($referrals->isNotEmpty())
                    <h2 class="font-semibold text-slate-900 mt-10 mb-4">Your referral codes</h2>
                    <ul class="space-y-2">
                        @foreach($referrals as $r)
                            <li class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                                <code class="font-mono text-primary-600">{{ $r->referral_code }}</code>
                                <span class="text-sm text-slate-500">{{ $r->status }}</span>
                            </li>
                        @endforeach
                    </ul>
                    {{ $referrals->links() }}
                @endif
            @else
                <p class="text-slate-600"> <a href="{{ route('login') }}" class="text-primary-600 font-medium hover:underline">Log in</a> or <a href="{{ route('register') }}" class="text-primary-600 font-medium hover:underline">Sign up</a> to create referral codes and earn.</p>
            @endauth
        </main>
        @include('partials.footer-upgrad')
    </div>
    @guest
        @include('partials.auth-modal')
    @endguest
</body>
</html>
