<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Testimonials – {{ config('app.name') }}</title>
    <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700&display=swap" rel="stylesheet" />
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased bg-white text-slate-800">
    <div class="min-h-screen flex flex-col">
        @include('partials.header-upgrad')
        <main class="flex-1 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <h1 class="text-3xl font-bold text-slate-900 mb-2">Why leaders choose us</h1>
            <p class="text-slate-600 mb-10">Real experiences from professionals completing courses worldwide.</p>
            @if($testimonials->isEmpty())
                <p class="text-slate-500">No testimonials yet. Check back later.</p>
            @else
                <div class="grid md:grid-cols-2 gap-8">
                    @foreach($testimonials as $t)
                        <div class="card">
                            <div class="card-body">
                                <p class="text-slate-700">&ldquo;{{ $t->quote }}&rdquo;</p>
                                @if($t->story)
                                    <p class="mt-3 text-sm text-slate-600">{{ Str::limit($t->story, 300) }}</p>
                                @endif
                                <div class="mt-4 flex items-center justify-between">
                                    <div class="flex items-center gap-3">
                                        <div class="w-12 h-12 rounded-full bg-primary-100 flex items-center justify-center text-primary-700 font-semibold">{{ strtoupper(substr($t->name, 0, 1)) }}</div>
                                        <div>
                                            <p class="font-semibold text-slate-900">{{ $t->name }}</p>
                                            <p class="text-sm text-slate-500">{{ $t->role }}@if($t->program) · {{ $t->program }}@endif</p>
                                        </div>
                                    </div>
                                    @if($t->linkedin_url)
                                        <a href="{{ $t->linkedin_url }}" target="_blank" rel="noopener" class="text-slate-400 hover:text-primary-600" aria-label="LinkedIn">@include('partials.icon-linkedin')</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </main>
        @include('partials.footer-upgrad')
    </div>
    @guest
        @include('partials.auth-modal')
    @endguest
</body>
</html>
