<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReferController;
use App\Http\Controllers\Web\WebCourseController;
use App\Http\Controllers\Web\WebDashboardController;
use App\Http\Controllers\Web\WebQuizController;
use Illuminate\Support\Facades\Route;

Route::get('/', HomeController::class)->name('home');
Route::get('/testimonials', function () {
    $testimonials = \App\Models\Testimonial::where('is_active', true)->orderBy('sort_order')->get();
    return view('testimonials', compact('testimonials'));
})->name('testimonials');
Route::get('/refer', [ReferController::class, 'index'])->name('refer.index');
Route::post('/refer', [ReferController::class, 'store'])->middleware('auth')->name('refer.store');

Route::get('/courses', [WebCourseController::class, 'index'])->name('courses.index');

Route::middleware(['auth', 'user.only'])->group(function () {
    Route::get('/dashboard', WebDashboardController::class)->name('dashboard');
    Route::get('/courses/my-courses', [WebCourseController::class, 'myCourses'])->name('courses.my-courses');
    Route::post('/courses/{course}/enroll', [WebCourseController::class, 'enroll'])->name('courses.enroll');
    Route::get('/learn/{course}', [WebCourseController::class, 'learn'])->name('courses.learn');
    Route::get('/learn/{course}/lesson/{lesson}', [WebCourseController::class, 'lesson'])->name('courses.lesson');
    Route::get('/quizzes', [WebQuizController::class, 'index'])->name('quizzes.index');
    Route::get('/quizzes/{quiz}', [WebQuizController::class, 'show'])->name('quizzes.show');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// This must come AFTER /courses/my-courses to avoid route conflicts
Route::get('/courses/{course}', [WebCourseController::class, 'show'])->name('courses.show');

require __DIR__.'/auth.php';
require __DIR__.'/admin.php';
