<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name')); ?> – World-class learning online</title>
        <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700,800&display=swap" rel="stylesheet" />
            <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="font-sans antialiased bg-white text-slate-800">
    <div class="min-h-screen flex flex-col">
        <?php echo $__env->make('partials.header-upgrad', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="flex-1">
            
            <section class="relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-slate-50 via-white to-primary-50/20"></div>
                <div class="absolute top-0 right-0 w-[600px] h-[600px] bg-primary-100/30 rounded-full blur-3xl -translate-y-1/2 translate-x-1/3"></div>
                <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-primary-50/40 rounded-full blur-3xl translate-y-1/2 -translate-x-1/4"></div>
                <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 lg:py-32">
                    <div class="grid lg:grid-cols-2 gap-16 items-center">
                        <div class="animate-slide-up">
                            <p class="text-primary-600 font-semibold text-sm uppercase tracking-wider mb-4">Learn from anywhere</p>
                            <h1 class="text-4xl sm:text-5xl lg:text-6xl xl:text-7xl font-extrabold text-slate-900 tracking-tight leading-[1.1]">
                                Earn a world-class <span class="text-primary-600">degree or certification</span> online
                            </h1>
                            <p class="mt-6 text-lg sm:text-xl text-slate-600 leading-relaxed max-w-xl">
                                Designed for aspiring leaders, educators & professionals worldwide. Structured courses, quizzes, and certifications—all in one place.
                            </p>
                            <div class="mt-10 flex flex-col sm:flex-row gap-4" x-data="{ domain: '' }">
                                <select x-model="domain" class="flex-1 min-w-[220px] py-3.5 px-4 rounded-xl border border-slate-300 bg-white text-slate-700 font-medium shadow-sm focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition">
                                    <option value="">Select your domain</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat->slug); ?>"><?php echo e($cat->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <a :href="domain ? '<?php echo e(url('courses')); ?>?category=' + domain : '<?php echo e(route('courses.index')); ?>'" class="btn-primary py-3.5 px-8 text-base whitespace-nowrap">Explore now</a>
                            </div>
                        </div>
                        <div class="relative hidden lg:block animate-fade-in">
                            <div class="aspect-square max-w-lg ml-auto rounded-3xl bg-gradient-to-br from-primary-100/60 via-primary-50/40 to-slate-100/60 flex items-center justify-center border border-white/50 shadow-soft-lg">
                                <div class="w-48 h-48 rounded-full bg-white/80 shadow-soft flex items-center justify-center">
                                    <svg class="w-24 h-24 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="py-14 bg-white border-y border-slate-100">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <p class="text-center text-sm font-semibold text-slate-500 uppercase tracking-wider mb-10">Trusted by learners worldwide</p>
                    <div class="flex flex-wrap justify-center gap-x-14 gap-y-6 items-center text-slate-500">
                        <?php $__currentLoopData = $categories->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="font-semibold text-slate-600"><?php echo e($c->name); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="mt-14 grid grid-cols-1 sm:grid-cols-3 gap-8">
                        <div class="text-center">
                            <p class="text-3xl sm:text-4xl font-extrabold text-primary-600"><?php echo e(number_format($stats['graduates'])); ?>+</p>
                            <p class="text-slate-500 font-medium mt-1">Learners</p>
                        </div>
                        <div class="text-center">
                            <p class="text-3xl sm:text-4xl font-extrabold text-primary-600"><?php echo e($stats['countries']); ?>+</p>
                            <p class="text-slate-500 font-medium mt-1">Countries</p>
                        </div>
                        <div class="text-center">
                            <p class="text-3xl sm:text-4xl font-extrabold text-primary-600"><?php echo e($stats['partnerships']); ?>+</p>
                            <p class="text-slate-500 font-medium mt-1">Programs</p>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="section-padding bg-slate-50/50">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="section-heading">Featured programs</h2>
                    <p class="section-subheading">Hand-picked programs for professionals.</p>
                    <div class="mt-12 grid sm:grid-cols-2 lg:grid-cols-3 gap-8">
                        <?php $__empty_1 = true; $__currentLoopData = $featuredCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(route('courses.show', $course)); ?>" class="course-card group">
                                <div class="aspect-[4/3] bg-gradient-to-br from-slate-100 to-slate-200 flex items-center justify-center relative overflow-hidden">
                                    <?php if($course->is_featured): ?>
                                        <span class="absolute top-4 left-4 bg-primary-600 text-white text-xs font-bold px-3 py-1.5 rounded-lg shadow">New</span>
                                    <?php endif; ?>
                                    <svg class="w-20 h-20 text-slate-400 group-hover:text-primary-400 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                                </div>
                                <div class="p-6">
                                    <p class="text-sm font-semibold text-primary-600"><?php echo e($course->category?->name); ?></p>
                                    <h3 class="font-bold text-slate-900 mt-2 text-lg line-clamp-2 group-hover:text-primary-600 transition-colors"><?php echo e($course->title); ?></h3>
                                    <div class="mt-4 flex flex-wrap gap-3 text-sm text-slate-500">
                                        <span><?php echo e($course->total_lessons); ?> lessons</span>
                                        <?php if($course->total_duration): ?>
                                            <span><?php echo e(round($course->total_duration / 60)); ?> hrs</span>
        <?php endif; ?>
                                    </div>
                                    <div class="mt-6 flex gap-3">
                                        <span class="btn-outline text-sm py-2 flex-1 text-center">View program</span>
                                        <span class="btn-primary text-sm py-2 flex-1 text-center">Enroll</span>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-span-full text-center py-16 px-6 rounded-2xl bg-white border border-slate-100">
                                <p class="text-slate-500">No featured programs yet.</p>
                                <a href="<?php echo e(route('courses.index')); ?>" class="inline-block mt-4 text-primary-600 font-semibold hover:underline">Browse all courses</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </section>

            
            <section class="section-padding bg-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="section-heading">Explore by category</h2>
                    <p class="section-subheading">Browse programs across exam types and professional certifications.</p>
                    <div class="flex flex-wrap gap-3 mt-10 mb-12">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('courses.index', ['category' => $cat->slug])); ?>" class="px-5 py-2.5 rounded-xl border-2 border-slate-200 text-sm font-semibold text-slate-700 hover:border-primary-500 hover:bg-primary-50 hover:text-primary-700 transition-all duration-200"><?php echo e($cat->name); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__currentLoopData = $categories->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('courses.index', ['category' => $cat->slug])); ?>" class="group flex items-center gap-4 p-6 rounded-2xl bg-slate-50 border border-slate-100 hover:border-primary-100 hover:bg-primary-50/30 transition-all duration-200">
                                <div class="w-14 h-14 rounded-xl bg-primary-100 flex items-center justify-center shrink-0 group-hover:bg-primary-200/50 transition-colors">
                                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                                </div>
                                <div>
                                    <h3 class="font-bold text-slate-900 group-hover:text-primary-700 transition-colors"><?php echo e($cat->name); ?></h3>
                                    <p class="text-sm text-slate-500 mt-0.5"><?php echo e($cat->courses()->where('is_active', true)->count()); ?> programs</p>
                                </div>
                                <svg class="w-5 h-5 text-slate-400 group-hover:text-primary-500 ml-auto shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="mt-12 text-center">
                        <a href="<?php echo e(route('courses.index')); ?>" class="btn-primary px-8">Explore all courses</a>
                    </div>
                </div>
            </section>

            
            <section class="section-padding bg-slate-50/50">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="section-heading">Free courses to get started</h2>
                    <p class="section-subheading">Build skills in today’s most relevant domains at no cost.</p>
                    <div class="mt-12 grid sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                        <?php $__empty_1 = true; $__currentLoopData = $freeCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(route('courses.show', $course)); ?>" class="course-card group">
                                <div class="p-6">
                                    <span class="text-xs font-bold text-emerald-600 uppercase tracking-wide">Free</span>
                                    <h3 class="font-bold text-slate-900 mt-2 line-clamp-2 group-hover:text-primary-600 transition-colors"><?php echo e($course->title); ?></h3>
                                    <p class="text-sm text-slate-500 mt-2"><?php echo e($course->total_lessons); ?> lessons · <?php echo e($course->total_duration ? round($course->total_duration/60) . ' hrs' : '—'); ?></p>
                                    <span class="mt-4 btn-primary text-sm py-2 block text-center w-full">Enroll now</span>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-span-full text-center py-16 px-6 rounded-2xl bg-white border border-slate-100">
                                <p class="text-slate-500">No free courses yet.</p>
                                <a href="<?php echo e(route('courses.index')); ?>" class="inline-block mt-4 text-primary-600 font-semibold hover:underline">Browse all courses</a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="mt-10 text-center">
                        <a href="<?php echo e(route('courses.index', ['type' => 'free'])); ?>" class="btn-outline px-8">View all free courses</a>
                    </div>
                </div>
            </section>

            
            <?php if($testimonials->isNotEmpty()): ?>
            <section class="section-padding bg-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="section-heading">Why learners choose us</h2>
                    <p class="section-subheading">Real experiences from professionals completing courses worldwide.</p>
                    <div class="mt-12 grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                        <?php $__currentLoopData = $testimonials->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-slate-50 rounded-2xl p-8 border border-slate-100 hover:border-primary-100 hover:shadow-soft transition-all duration-200">
                                <p class="text-slate-700 leading-relaxed">&ldquo;<?php echo e(Str::limit($t->quote, 160)); ?>&rdquo;</p>
                                <div class="mt-6 flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-full bg-primary-100 flex items-center justify-center text-primary-700 font-bold text-lg"><?php echo e(strtoupper(substr($t->name, 0, 1))); ?></div>
                                    <div>
                                        <p class="font-bold text-slate-900"><?php echo e($t->name); ?></p>
                                        <p class="text-sm text-slate-500"><?php echo e($t->role); ?><?php if($t->program): ?> · <?php echo e($t->program); ?><?php endif; ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="mt-10 text-center">
                        <a href="<?php echo e(route('testimonials')); ?>" class="text-primary-600 font-semibold hover:underline">Read more stories →</a>
                    </div>
                </div>
            </section>
            <?php endif; ?>

            
            <section id="support" class="section-padding bg-slate-900 text-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="text-3xl lg:text-4xl font-bold tracking-tight">How we support you every step of the way</h2>
                    <p class="mt-3 text-slate-300 text-lg max-w-2xl">Your learning journey is unique—we’re here to make it rewarding from day one.</p>
                    <div class="mt-16 grid sm:grid-cols-2 lg:grid-cols-5 gap-6">
                        <?php $__currentLoopData = [
                            ['num' => '1', 'title' => 'Right fit', 'desc' => 'We guide you to the right program with goal-based recommendations.'],
                            ['num' => '2', 'title' => 'Effortless enrollment', 'desc' => 'No paperwork. Stress-free onboarding and payments.'],
                            ['num' => '3', 'title' => 'Learn on your time', 'desc' => 'Flexible access to lessons and recordings.'],
                            ['num' => '4', 'title' => 'Support when you need it', 'desc' => 'Help is within reach so you don’t learn alone.'],
                            ['num' => '5', 'title' => 'Community', 'desc' => 'Join a network of learners and grow together.'],
                        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="rounded-2xl bg-white/10 backdrop-blur p-6 border border-white/10 hover:bg-white/15 transition-all duration-200">
                                <span class="inline-flex w-10 h-10 items-center justify-center rounded-xl bg-primary-500/80 text-lg font-bold"><?php echo e($step['num']); ?></span>
                                <h3 class="font-bold text-lg mt-4"><?php echo e($step['title']); ?></h3>
                                <p class="text-slate-300 text-sm mt-2 leading-relaxed"><?php echo e($step['desc']); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </section>
            </main>

        <?php echo $__env->make('partials.footer-upgrad', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    <?php if(auth()->guard()->guest()): ?>
        <?php echo $__env->make('partials.auth-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    </body>
</html>
<?php /**PATH /Library/WebServer/Documents/iid-new-project/products/e-commerce/lms-portal/resources/views/welcome.blade.php ENDPATH**/ ?>