<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($course->title); ?> – <?php echo e(config('app.name')); ?></title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700,800&display=swap" rel="stylesheet" />
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="font-sans antialiased bg-white text-slate-800">
    <div class="min-h-screen flex flex-col">
        <?php echo $__env->make('partials.header-upgrad', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="flex-1">
            
            <?php if(session('error')): ?>
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-6">
                    <div class="bg-red-50 border-l-4 border-red-500 text-red-700 p-4 rounded-r-lg flex items-center gap-3">
                        <svg class="w-5 h-5 shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                        <p class="font-medium"><?php echo e(session('error')); ?></p>
                    </div>
                </div>
            <?php endif; ?>
            <?php if(session('message')): ?>
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-6">
                    <div class="bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-r-lg flex items-center gap-3">
                        <svg class="w-5 h-5 shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <p class="font-medium"><?php echo e(session('message')); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            
            <section class="relative bg-gradient-to-br from-slate-50 via-white to-primary-50/30 overflow-hidden">
                <div class="absolute top-0 right-0 w-[600px] h-[600px] bg-primary-100/20 rounded-full blur-3xl -translate-y-1/2 translate-x-1/3"></div>
                <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12 lg:py-20">
                    <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-start">
                        
                        <div>
                            <div class="flex flex-wrap items-center gap-3 mb-4">
                                <span class="badge-primary text-xs px-3 py-1"><?php echo e($course->category->name ?? 'Course'); ?></span>
                                <?php if($course->type === 'free'): ?>
                                    <span class="badge-success text-xs px-3 py-1">Free</span>
                                <?php else: ?>
                                    <span class="badge-warning text-xs px-3 py-1">Premium</span>
                                <?php endif; ?>
                                <?php if($course->is_featured): ?>
                                    <span class="bg-primary-600 text-white text-xs font-bold px-3 py-1 rounded-lg">Featured</span>
                                <?php endif; ?>
                            </div>
                            <h1 class="text-4xl sm:text-5xl lg:text-6xl font-extrabold text-slate-900 tracking-tight leading-[1.1] mb-6">
                                <?php echo e($course->title); ?>

                            </h1>
                            <p class="text-lg sm:text-xl text-slate-600 leading-relaxed mb-8">
                                <?php echo e($course->description); ?>

                            </p>
                            
                            
                            <div class="flex flex-wrap gap-6 mb-8 pb-8 border-b border-slate-200">
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                                    <span class="text-slate-700 font-semibold"><?php echo e($course->total_lessons); ?> Lessons</span>
                                </div>
                                <?php if($course->total_duration): ?>
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                                    <span class="text-slate-700 font-semibold"><?php echo e(round($course->total_duration/60)); ?> Hours</span>
                                </div>
                                <?php endif; ?>
                                <?php if($course->level): ?>
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/></svg>
                                    <span class="text-slate-700 font-semibold"><?php echo e(ucfirst($course->level)); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>

                            
                            <div class="flex flex-col sm:flex-row gap-4 mb-8">
                                <?php if($enrolled): ?>
                                    <a href="<?php echo e(route('courses.learn', $course)); ?>" class="btn-primary py-3.5 px-8 text-base text-center">
                                        Continue Learning
                                    </a>
                                <?php else: ?>
                                    <form action="<?php echo e(route('courses.enroll', $course)); ?>" method="POST" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn-primary py-3.5 px-8 text-base w-full sm:w-auto">
                                            <?php echo e($course->type === 'free' ? 'Enroll for Free' : 'Enroll Now — ₹' . number_format($course->price)); ?>

                                        </button>
                                    </form>
                                <?php endif; ?>
                                <?php if($course->demo_video_url): ?>
                                <a href="<?php echo e($course->demo_video_url); ?>" target="_blank" class="btn-outline py-3.5 px-8 text-base text-center">
                                    Watch Demo
                                </a>
                                <?php endif; ?>
                            </div>

                            
                            <div class="flex flex-wrap items-center gap-6 text-sm text-slate-500">
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-emerald-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>
                                    <span class="font-medium">Certificate Included</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                                    <span class="font-medium">Lifetime Access</span>
                                </div>
                            </div>
                        </div>

                        
                        <div class="relative">
                            <?php if($course->thumbnail): ?>
                                <img src="<?php echo e(asset('storage/' . $course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>" class="w-full rounded-3xl shadow-2xl border border-slate-200">
                            <?php else: ?>
                                <div class="aspect-[4/3] rounded-3xl bg-gradient-to-br from-primary-100 via-primary-50 to-slate-100 flex items-center justify-center border border-slate-200 shadow-2xl">
                                    <svg class="w-32 h-32 text-primary-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>

            
            <section id="highlights" class="py-16 lg:py-24 bg-slate-50/50">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-16">
                        
                        <div class="bg-white rounded-xl p-8 shadow-sm border border-slate-200 hover:shadow-md transition-shadow text-center">
                            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-primary-50 border-2 border-primary-600 flex items-center justify-center">
                                <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                                </svg>
                            </div>
                            <p class="text-slate-900 font-semibold text-base leading-snug">Comprehensive Learning Path</p>
                        </div>

                        
                        <div class="bg-white rounded-xl p-8 shadow-sm border border-slate-200 hover:shadow-md transition-shadow text-center">
                            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-primary-50 border-2 border-primary-600 flex items-center justify-center">
                                <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                </svg>
                            </div>
                            <p class="text-slate-900 font-semibold text-base leading-snug">Hands-on Projects - Every module ends with practical application</p>
                        </div>

                        
                        <div class="bg-white rounded-xl p-8 shadow-sm border border-slate-200 hover:shadow-md transition-shadow text-center">
                            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-primary-50 border-2 border-primary-600 flex items-center justify-center">
                                <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                                </svg>
                            </div>
                            <p class="text-slate-900 font-semibold text-base leading-snug">In-Depth Content - Learn concepts step-by-step with real-world examples</p>
                        </div>

                        
                        <div class="bg-white rounded-xl p-8 shadow-sm border border-slate-200 hover:shadow-md transition-shadow text-center">
                            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-primary-50 border-2 border-primary-600 flex items-center justify-center">
                                <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <p class="text-slate-900 font-semibold text-base leading-snug">Industry-Relevant Skills - Build expertise across multiple domains and use cases</p>
                        </div>

                        
                        <div class="bg-white rounded-xl p-8 shadow-sm border border-slate-200 hover:shadow-md transition-shadow text-center">
                            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-primary-50 border-2 border-primary-600 flex items-center justify-center">
                                <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                                </svg>
                            </div>
                            <p class="text-slate-900 font-semibold text-base leading-snug">Earn Professional Certification - Industry-recognized certificate upon completion</p>
                        </div>

                        
                        <div class="bg-white rounded-xl p-8 shadow-sm border border-slate-200 hover:shadow-md transition-shadow text-center">
                            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-primary-50 border-2 border-primary-600 flex items-center justify-center">
                                <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                            </div>
                            <p class="text-slate-900 font-semibold text-base leading-snug">Modern Tools & Resources - Access to industry-standard tools and platforms</p>
                        </div>
                    </div>

                    
                    <div class="text-center mb-12">
                        <h2 class="text-4xl lg:text-5xl font-bold text-slate-900 mb-4">
                            <?php echo e($course->title); ?>: <span class="text-primary-600">Build What's Next</span>
                        </h2>
                    </div>

                    
                    <div class="grid sm:grid-cols-3 gap-8 max-w-4xl mx-auto">
                        <div class="text-center">
                            <p class="text-3xl lg:text-4xl font-bold text-slate-900 mb-2">
                                <?php echo e($course->total_duration ? round($course->total_duration / 60) : '100'); ?>+
                            </p>
                            <p class="text-slate-600 font-medium">Hours of Learning</p>
                        </div>
                        <div class="text-center">
                            <p class="text-3xl lg:text-4xl font-bold text-slate-900 mb-2">
                                <?php echo e(max(1, ceil($course->lessons->count() / 4))); ?>+
                            </p>
                            <p class="text-slate-600 font-medium">Projects</p>
                        </div>
                        <div class="text-center">
                            <p class="text-3xl lg:text-4xl font-bold text-slate-900 mb-2">
                                <?php echo e($course->total_lessons); ?>+
                            </p>
                            <p class="text-slate-600 font-medium">Lessons</p>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="sticky top-16 z-40 bg-white border-b border-slate-200 shadow-sm" x-data="{ activeTab: 'highlights' }">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="flex items-center justify-between gap-4 overflow-x-auto scrollbar-hide">
                        <nav class="flex items-center gap-1 min-w-0" role="tablist">
                            <a href="#highlights" @click="activeTab = 'highlights'" :class="activeTab === 'highlights' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Key Highlights</a>
                            <a href="#snapshot" @click="activeTab = 'snapshot'" :class="activeTab === 'snapshot' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Course Snapshot</a>
                            <a href="#learning-path" @click="activeTab = 'learning-path'" :class="activeTab === 'learning-path' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Learning Path</a>
                            <a href="#curriculum" @click="activeTab = 'curriculum'" :class="activeTab === 'curriculum' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Curriculum</a>
                            <a href="#projects" @click="activeTab = 'projects'" :class="activeTab === 'projects' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Projects</a>
                            <a href="#certificate" @click="activeTab = 'certificate'" :class="activeTab === 'certificate' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Certificate</a>
                            <a href="#instructors" @click="activeTab = 'instructors'" :class="activeTab === 'instructors' ? 'text-primary-600 border-b-2 border-primary-600' : 'text-slate-600 hover:text-slate-900'" class="px-4 py-4 text-sm font-semibold whitespace-nowrap transition border-b-2 border-transparent">Instructors</a>
                        </nav>
                        <div class="flex items-center gap-3 shrink-0">
                            <?php if($course->syllabus): ?>
                            <button onclick="window.print()" class="px-4 py-2 text-sm font-semibold text-slate-700 border border-slate-300 rounded-lg hover:bg-slate-50 transition whitespace-nowrap">Syllabus</button>
                            <?php endif; ?>
                            <?php if(!$enrolled): ?>
                            <form action="<?php echo e(route('courses.enroll', $course)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn-primary px-6 py-2 text-sm whitespace-nowrap">
                                    <?php echo e($course->type === 'free' ? 'Enroll Free' : 'Apply Now'); ?>

                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>

            
            <section id="curriculum" class="py-16 lg:py-24 bg-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="text-3xl lg:text-4xl font-bold text-slate-900 mb-2">
                        <?php echo e($course->title); ?> <span class="text-primary-600">Curriculum</span>
                    </h2>
                    <?php if($course->syllabus): ?>
                        <p class="text-lg text-slate-600 mb-12 max-w-3xl"><?php echo e(\Illuminate\Support\Str::limit($course->syllabus, 150)); ?></p>
                    <?php endif; ?>

                    <?php
                        // Group lessons into modules intelligently (same logic as learning page)
                        $lessons = $course->lessons->sortBy('sort_order');
                        $modules = [];
                        
                        if ($lessons->count() > 0) {
                            $lessonsPerModule = max(4, min(6, ceil($lessons->count() / max(4, floor($lessons->count() / 6)))));
                            $moduleIndex = 0;
                            $currentModuleLessons = [];
                            
                            foreach ($lessons as $index => $l) {
                                // Check if this lesson starts a new section
                                $shouldStartNewModule = empty($currentModuleLessons) || 
                                    count($currentModuleLessons) >= $lessonsPerModule ||
                                    (str_contains(strtolower($l->title), 'section') || 
                                     str_contains(strtolower($l->title), 'module') ||
                                     str_contains(strtolower($l->title), 'project') ||
                                     str_contains(strtolower($l->title), 'deployment'));
                                
                                if ($shouldStartNewModule && !empty($currentModuleLessons)) {
                                    $moduleIndex++;
                                    $firstLessonTitle = $currentModuleLessons[0]->title;
                                    $moduleTitle = $firstLessonTitle;
                                    if (preg_match('/^(Section \d+|Module \d+)[:\-]?\s*(.+)$/i', $firstLessonTitle, $matches)) {
                                        $moduleTitle = trim($matches[1] . ': ' . $matches[2]);
                                    } elseif (strlen($firstLessonTitle) > 40) {
                                        $moduleTitle = 'Section ' . $moduleIndex . ': ' . substr($firstLessonTitle, 0, 30) . '...';
                                    } else {
                                        $moduleTitle = 'Section ' . $moduleIndex . ': ' . $firstLessonTitle;
                                    }
                                    
                                    $modules[] = [
                                        'number' => $moduleIndex,
                                        'title' => $moduleTitle,
                                        'lessons' => $currentModuleLessons,
                                        'weeks' => max(1, ceil(count($currentModuleLessons) / 2)),
                                    ];
                                    $currentModuleLessons = [];
                                }
                                
                                $currentModuleLessons[] = $l;
                            }
                            
                            // Add remaining lessons
                            if (!empty($currentModuleLessons)) {
                                $moduleIndex++;
                                $firstLessonTitle = $currentModuleLessons[0]->title;
                                $moduleTitle = strlen($firstLessonTitle) > 40 
                                    ? 'Section ' . $moduleIndex . ': ' . substr($firstLessonTitle, 0, 30) . '...'
                                    : 'Section ' . $moduleIndex . ': ' . $firstLessonTitle;
                                
                                $modules[] = [
                                    'number' => $moduleIndex,
                                    'title' => $moduleTitle,
                                    'lessons' => $currentModuleLessons,
                                    'weeks' => max(1, ceil(count($currentModuleLessons) / 2)),
                                ];
                            }
                        }
                    ?>

                    <div class="max-w-5xl mx-auto relative" x-data="{ openModules: [1] }">
                        
                        <div class="absolute left-6 top-0 bottom-0 w-0.5 bg-primary-600 hidden lg:block" style="height: calc(100% - 2rem); margin-top: 2rem;"></div>

                        <div class="space-y-4">
                            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="relative bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden hover:shadow-md transition-shadow" 
                                     x-data="{ open: openModules.includes(<?php echo e($module['number']); ?>) }"
                                     x-init="$watch('open', value => {
                                         if (value && !openModules.includes(<?php echo e($module['number']); ?>)) {
                                             openModules.push(<?php echo e($module['number']); ?>);
                                         } else if (!value) {
                                             openModules = openModules.filter(m => m !== <?php echo e($module['number']); ?>);
                                         }
                                     })">
                                    
                                    <div class="absolute left-6 top-6 w-4 h-4 bg-primary-600 rounded-full border-4 border-white shadow-sm hidden lg:block z-10"></div>

                                    
                                    <button @click="open = !open" class="w-full p-6 lg:pl-20 text-left flex items-center justify-between gap-4 hover:bg-slate-50/50 transition">
                                        <div class="flex-1 min-w-0">
                                            <h3 class="text-xl font-bold text-slate-900 mb-1"><?php echo e($module['title']); ?></h3>
                                            <p class="text-sm text-slate-600">Module <?php echo e($module['number']); ?> • <?php echo e($module['weeks']); ?> <?php echo e($module['weeks'] === 1 ? 'Week' : 'Weeks'); ?></p>
                                        </div>
                                        <svg class="w-5 h-5 text-primary-600 shrink-0 transition-transform duration-200" :class="open && 'rotate-180'" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                        </svg>
                                    </button>

                                    
                                    <div x-show="open" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-cloak class="border-t border-slate-100">
                                        <div class="p-6 lg:pl-20">
                                            <?php if($module['lessons'][0]->description ?? null): ?>
                                                <p class="text-slate-700 mb-6 leading-relaxed"><?php echo e($module['lessons'][0]->description); ?></p>
                                            <?php endif; ?>
                                            <div class="grid md:grid-cols-2 gap-8">
                                                
                                                <div>
                                                    <h4 class="font-bold text-slate-900 mb-4">Key Topics</h4>
                                                    <ul class="space-y-3">
                                                        <?php $__currentLoopData = $module['lessons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="flex items-start gap-3">
                                                                <svg class="w-5 h-5 text-slate-700 shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                                                </svg>
                                                                <div class="flex-1">
                                                                    <span class="text-slate-700 font-medium"><?php echo e($lesson->title); ?></span>
                                                                    <?php if($lesson->duration): ?>
                                                                        <span class="text-slate-500 text-sm ml-2">(<?php echo e($lesson->duration); ?> min)</span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>

                                                
                                                <div>
                                                    <h4 class="font-bold text-slate-900 mb-4">Sample Projects</h4>
                                                    <div class="flex flex-wrap gap-2">
                                                        <?php
                                                            // Generate sample project names based on module/lesson titles
                                                            $projectNames = [
                                                                'Practical assignment: ' . ($module['lessons'][0]->title ?? 'Module Project'),
                                                                'Hands-on exercise: ' . ($module['lessons'][1]->title ?? 'Case Study'),
                                                                'Real-world application',
                                                                'Capstone project component',
                                                            ];
                                                            $projects = array_slice($projectNames, 0, min(3, count($module['lessons'])));
                                                        ?>
                                                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <span class="inline-flex items-center px-3 py-1.5 rounded-lg bg-slate-100 text-slate-700 text-sm font-medium border border-slate-200 shadow-sm">
                                                                <?php echo e($project); ?>

                                                            </span>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(count($module['lessons']) > 3): ?>
                                                            <span class="inline-flex items-center px-3 py-1.5 rounded-lg bg-slate-100 text-slate-700 text-sm font-medium border border-slate-200 shadow-sm">
                                                                +<?php echo e(count($module['lessons']) - 3); ?> more
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </section>

            
            <?php if($course->instructor): ?>
            <section class="py-16 lg:py-24 bg-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h2 class="text-3xl lg:text-4xl font-bold text-slate-900 text-center mb-12">Meet Your Instructor</h2>
                    <div class="max-w-3xl mx-auto">
                        <div class="bg-white rounded-2xl border border-slate-200 p-8 flex flex-col sm:flex-row gap-6">
                            <div class="shrink-0">
                                <div class="w-24 h-24 rounded-full bg-primary-100 flex items-center justify-center text-primary-700 text-2xl font-bold">
                                    <?php echo e(strtoupper(substr($course->instructor->name, 0, 1))); ?>

                                </div>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-2xl font-bold text-slate-900 mb-2"><?php echo e($course->instructor->name); ?></h3>
                                <p class="text-slate-600 mb-4"><?php echo e($course->instructor->email); ?></p>
                                <p class="text-slate-700 leading-relaxed">Experienced instructor dedicated to your learning success.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <?php endif; ?>

            
            <?php if($testimonials->count() > 0): ?>
            <section class="py-16 lg:py-24 bg-slate-50/50">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="text-center mb-12">
                        <h2 class="text-3xl lg:text-4xl font-bold text-slate-900 mb-4">What Our Learners Say</h2>
                        <p class="text-lg text-slate-600 max-w-2xl mx-auto">Real stories from successful graduates</p>
                    </div>
                    <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__currentLoopData = $testimonials->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-white rounded-2xl border border-slate-200 p-6 hover:shadow-lg transition-shadow">
                                <div class="flex items-center gap-4 mb-4">
                                    <div class="w-12 h-12 rounded-full bg-primary-100 flex items-center justify-center text-primary-700 font-bold shrink-0">
                                        <?php echo e(strtoupper(substr($testimonial->name, 0, 1))); ?>

                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-slate-900"><?php echo e($testimonial->name); ?></h4>
                                        <p class="text-sm text-slate-600"><?php echo e($testimonial->role); ?></p>
                                    </div>
                                </div>
                                <p class="text-slate-700 leading-relaxed line-clamp-4">"<?php echo e($testimonial->quote); ?>"</p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </section>
            <?php endif; ?>

            
            <?php if($relatedCourses->count() > 0): ?>
            <section class="py-16 lg:py-24 bg-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="flex items-center justify-between mb-12">
                        <div>
                            <h2 class="text-3xl lg:text-4xl font-bold text-slate-900 mb-2">Related Programs</h2>
                            <p class="text-lg text-slate-600">Explore more courses in this category</p>
                        </div>
                        <a href="<?php echo e(route('courses.index', ['category' => $course->category->slug ?? ''])); ?>" class="hidden sm:inline-flex btn-outline">View All</a>
                    </div>
                    <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-8">
                        <?php $__currentLoopData = $relatedCourses->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('courses.show', $related)); ?>" class="course-card group">
                                <div class="aspect-[4/3] bg-gradient-to-br from-slate-100 to-slate-200 flex items-center justify-center relative overflow-hidden">
                                    <?php if($related->is_featured): ?>
                                        <span class="absolute top-4 left-4 bg-primary-600 text-white text-xs font-bold px-3 py-1.5 rounded-lg shadow">New</span>
                                    <?php endif; ?>
                                    <svg class="w-20 h-20 text-slate-400 group-hover:text-primary-400 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                                </div>
                                <div class="p-6">
                                    <p class="text-sm font-semibold text-primary-600"><?php echo e($related->category?->name); ?></p>
                                    <h3 class="font-bold text-slate-900 mt-2 text-lg line-clamp-2 group-hover:text-primary-600 transition-colors"><?php echo e($related->title); ?></h3>
                                    <div class="mt-4 flex flex-wrap gap-3 text-sm text-slate-500">
                                        <span><?php echo e($related->total_lessons); ?> lessons</span>
                                        <?php if($related->total_duration): ?>
                                            <span><?php echo e(round($related->total_duration / 60)); ?> hrs</span>
                                        <?php endif; ?>
                                        <?php if($related->type === 'free'): ?>
                                            <span class="text-emerald-600 font-semibold">Free</span>
                                        <?php else: ?>
                                            <span class="font-semibold">₹<?php echo e(number_format($related->price)); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="text-center mt-10">
                        <a href="<?php echo e(route('courses.index')); ?>" class="btn-primary inline-flex">Explore All Courses</a>
                    </div>
                </div>
            </section>
            <?php endif; ?>

            
            <section class="py-16 lg:py-24 bg-gradient-to-br from-slate-900 to-slate-800 text-white">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                    <h2 class="text-3xl lg:text-4xl font-bold mb-4">Ready to Start Learning?</h2>
                    <p class="text-lg text-slate-300 mb-8 max-w-2xl mx-auto">Join thousands of learners advancing their careers with our programs</p>
                    <?php if(!$enrolled): ?>
                        <form action="<?php echo e(route('courses.enroll', $course)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="bg-white text-primary-600 hover:bg-slate-100 px-8 py-3.5 rounded-xl font-semibold text-lg transition">
                                <?php echo e($course->type === 'free' ? 'Enroll for Free' : 'Enroll Now — ₹' . number_format($course->price)); ?>

                            </button>
                        </form>
                    <?php else: ?>
                        <a href="<?php echo e(route('courses.learn', $course)); ?>" class="bg-white text-primary-600 hover:bg-slate-100 px-8 py-3.5 rounded-xl font-semibold text-lg transition inline-block">
                            Continue Learning
                        </a>
                    <?php endif; ?>
                </div>
            </section>
        </main>

        
        <button 
            onclick="window.scrollTo({ top: 0, behavior: 'smooth' })"
            class="fixed bottom-8 left-8 z-50 w-12 h-12 bg-white rounded-full shadow-lg border border-slate-200 flex items-center justify-center text-primary-600 hover:bg-primary-50 hover:shadow-xl transition-all duration-200"
            aria-label="Scroll to top"
            x-data="{ show: false }"
            x-init="
                window.addEventListener('scroll', () => {
                    show = window.scrollY > 300;
                });
            "
            x-show="show"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 scale-90"
            x-transition:enter-end="opacity-100 scale-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100 scale-100"
            x-transition:leave-end="opacity-0 scale-90"
        >
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"/>
            </svg>
        </button>

        <?php echo $__env->make('partials.footer-upgrad', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    <?php if(auth()->guard()->guest()): ?>
        <?php echo $__env->make('partials.auth-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>

    <script>
        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                const href = this.getAttribute('href');
                if (href !== '#' && href.length > 1) {
                    e.preventDefault();
                    const target = document.querySelector(href);
                    if (target) {
                        const offset = 80; // Account for sticky header
                        const targetPosition = target.getBoundingClientRect().top + window.pageYOffset - offset;
                        window.scrollTo({
                            top: targetPosition,
                            behavior: 'smooth'
                        });
                    }
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /Library/WebServer/Documents/iid-new-project/products/e-commerce/lms-portal/resources/views/courses/show.blade.php ENDPATH**/ ?>