<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Courses</h1>
        <p class="text-slate-600 mt-0.5">
            <?php if(request('type') === 'free'): ?>
                Free courses to get started.
            <?php elseif(request('category')): ?>
                <?php echo e($categories->firstWhere('slug', request('category'))?->name ?? 'Programs'); ?>

            <?php else: ?>
                Browse all programs and certifications.
            <?php endif; ?>
        </p>
     <?php $__env->endSlot(); ?>

    <div class="space-y-8">
        <?php if($courses->count()): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('courses.show', $course)); ?>" class="course-card group">
                        <?php if($course->thumbnail): ?>
                            <img src="<?php echo e(asset('storage/' . $course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>" class="w-full h-44 object-cover group-hover:scale-[1.02] transition duration-300">
                        <?php else: ?>
                            <div class="w-full h-44 bg-gradient-to-br from-slate-100 to-slate-200 flex items-center justify-center">
                                <svg class="w-16 h-16 text-slate-400 group-hover:text-primary-400 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                            </div>
                        <?php endif; ?>
                        <div class="p-6">
                            <div class="flex items-center gap-2 flex-wrap">
                                <span class="text-xs font-semibold text-primary-600"><?php echo e($course->category->name ?? 'Course'); ?></span>
                                <?php if($course->type === 'free'): ?>
                                    <span class="badge-success">Free</span>
                                <?php else: ?>
                                    <span class="badge-warning">₹<?php echo e(number_format($course->price)); ?></span>
                                <?php endif; ?>
                            </div>
                            <h3 class="font-bold text-slate-900 mt-2 line-clamp-2 group-hover:text-primary-600 transition-colors"><?php echo e($course->title); ?></h3>
                            <p class="text-sm text-slate-500 mt-2 line-clamp-2"><?php echo e(Str::limit($course->description, 80)); ?></p>
                            <div class="mt-4 flex justify-between items-center text-sm text-slate-500">
                                <span><?php echo e($course->total_lessons); ?> lessons</span>
                                <?php if($course->total_duration): ?>
                                    <span><?php echo e(round($course->total_duration / 60)); ?> hrs</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php if($courses->hasPages()): ?>
                <div class="flex justify-center pt-4"><?php echo e($courses->links()); ?></div>
            <?php endif; ?>
        <?php else: ?>
            <div class="card overflow-hidden">
                <div class="card-body text-center py-16">
                    <p class="text-slate-500 text-lg">No courses available yet.</p>
                    <a href="<?php echo e(route('home')); ?>" class="inline-block mt-4 text-primary-600 font-semibold hover:underline">Back to home</a>
                </div>
            </div>
        <?php endif; ?>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/iid-new-project/products/e-commerce/lms-portal/resources/views/courses/index.blade.php ENDPATH**/ ?>