<header class="sticky top-0 z-50 bg-white/95 backdrop-blur-md border-b border-slate-200/80 shadow-sm">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16 lg:h-18">
            <a href="<?php echo e(route('home')); ?>" class="flex items-center gap-2 shrink-0">
                <span class="text-2xl font-extrabold text-primary-600 tracking-tight">LMS</span>
                <span class="text-xl font-bold text-slate-800 tracking-tight">Portal</span>
            </a>

            <nav class="hidden lg:flex items-center gap-0.5">
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" @click.outside="open = false" class="flex items-center gap-1.5 px-4 py-2.5 rounded-lg text-sm font-semibold text-slate-700 hover:text-primary-600 hover:bg-slate-50 transition">
                        Programs
                        <svg class="w-4 h-4 transition-transform" :class="open && 'rotate-180'" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </button>
                    <div x-show="open" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" x-cloak class="absolute left-0 top-full mt-1 w-72 bg-white rounded-xl shadow-soft-lg border border-slate-200 py-2 max-h-96 overflow-y-auto">
                        <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('courses.index', ['category' => $cat->slug])); ?>" class="block px-4 py-2.5 text-sm font-medium text-slate-700 hover:bg-primary-50 hover:text-primary-700 transition"><?php echo e($cat->name); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('courses.index')); ?>" class="block px-4 py-2.5 text-sm font-semibold text-primary-600 border-t border-slate-100 mt-2 pt-3">View all programs</a>
                    </div>
                </div>
                <a href="<?php echo e(route('courses.index', ['type' => 'free'])); ?>" class="px-4 py-2.5 rounded-lg text-sm font-semibold text-slate-700 hover:text-primary-600 hover:bg-slate-50 transition">Free Courses</a>
                <a href="<?php echo e(route('refer.index')); ?>" class="px-4 py-2.5 rounded-lg text-sm font-semibold text-slate-700 hover:text-primary-600 hover:bg-slate-50 transition">Refer & Earn</a>
                <a href="<?php echo e(route('testimonials')); ?>" class="px-4 py-2.5 rounded-lg text-sm font-semibold text-slate-700 hover:text-primary-600 hover:bg-slate-50 transition">Testimonials</a>
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" @click.outside="open = false" class="flex items-center gap-1.5 px-4 py-2.5 rounded-lg text-sm font-semibold text-slate-700 hover:text-primary-600 hover:bg-slate-50 transition">
                        More
                        <svg class="w-4 h-4 transition-transform" :class="open && 'rotate-180'" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </button>
                    <div x-show="open" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 translate-y-1" x-cloak class="absolute left-0 top-full mt-1 w-56 bg-white rounded-xl shadow-soft-lg border border-slate-200 py-2">
                        <a href="<?php echo e(route('home')); ?>#support" class="block px-4 py-2.5 text-sm font-medium text-slate-700 hover:bg-primary-50 transition">About Us</a>
                        <a href="<?php echo e(route('courses.index')); ?>" class="block px-4 py-2.5 text-sm font-medium text-slate-700 hover:bg-primary-50 transition">All Courses</a>
                    </div>
                </div>
            </nav>

            <div class="flex items-center gap-3">
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('dashboard')); ?>" class="hidden sm:inline text-sm font-semibold text-slate-600 hover:text-primary-600 transition">Dashboard</a>
                    <?php if(auth()->user()->isAdmin()): ?>
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-sm font-semibold text-primary-600 hover:text-primary-700">Admin</a>
                    <?php endif; ?>
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" @click.outside="open = false" class="flex items-center gap-2 px-2.5 py-2 rounded-xl hover:bg-slate-100 transition">
                            <span class="w-9 h-9 rounded-xl bg-primary-100 text-primary-700 flex items-center justify-center text-sm font-bold"><?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?></span>
                            <svg class="w-4 h-4 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                        </button>
                        <div x-show="open" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 translate-y-1" x-cloak class="absolute right-0 top-full mt-1.5 w-52 bg-white rounded-xl shadow-soft-lg border border-slate-200 py-1.5">
                            <a href="<?php echo e(route('profile.edit')); ?>" class="block px-4 py-2.5 text-sm font-medium text-slate-700 hover:bg-slate-50 transition">Edit Profile</a>
                            <a href="<?php echo e(route('courses.my-courses')); ?>" class="block px-4 py-2.5 text-sm font-medium text-slate-700 hover:bg-slate-50 transition">My Courses</a>
                            <form method="POST" action="<?php echo e(route('logout')); ?>"><?php echo csrf_field(); ?>
                                <button type="submit" class="block w-full text-left px-4 py-2.5 text-sm font-medium text-slate-700 hover:bg-slate-50 transition">Log out</button>
                            </form>
                        </div>
                    </div>
                <?php else: ?>
                    <button type="button" onclick="window.dispatchEvent(new CustomEvent('open-auth-modal', { detail: { tab: 'login' } }))" class="px-4 py-2.5 text-sm font-semibold text-slate-700 hover:text-primary-600 transition">Log in</button>
                    <button type="button" onclick="window.dispatchEvent(new CustomEvent('open-auth-modal', { detail: { tab: 'register' } }))" class="btn-primary text-sm py-2.5 px-5">Sign up</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</header>
<?php /**PATH /Library/WebServer/Documents/iid-new-project/products/e-commerce/lms-portal/resources/views/partials/header-upgrad.blade.php ENDPATH**/ ?>